/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BuildPropertyWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_DIRECTIVE = "name";
    public static final String PROP_VALUE = "value";
    private BasicPropertySupport m_propertySupport;
    private StyledTextField m_directiveField;
    private StyledTextField m_valueField;
    private Set<String> m_illegalNames;

    public BuildPropertyWizardPage() {
        super(BuildPropertyWizardPage.class.getName());
        this.setTitle(Texts.get("WsBuildDirective"));
        this.m_illegalNames = new HashSet<String>();
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.setDescription("");
    }

    protected void createContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.m_directiveField = this.getFieldToolkit().createStyledTextField(container, Texts.get("Name"));
        this.m_directiveField.setText(StringUtility.nvl((Object)this.getDirective(), (String)""));
        this.m_directiveField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertyWizardPage.this.setDirectiveInternal(BuildPropertyWizardPage.this.m_directiveField.getText());
                BuildPropertyWizardPage.this.pingStateChanging();
            }
        });
        this.m_valueField = this.getFieldToolkit().createStyledTextField(container, Texts.get("Value"));
        this.m_valueField.setText(StringUtility.nvl((Object)this.getValue(), (String)""));
        this.m_valueField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertyWizardPage.this.setValueInternal(BuildPropertyWizardPage.this.m_valueField.getText());
                BuildPropertyWizardPage.this.pingStateChanging();
            }
        });
        container.setLayout((Layout)new GridLayout(1, true));
        this.m_directiveField.setLayoutData((Object)new GridData(768));
        this.m_valueField.setLayoutData((Object)new GridData(768));
    }

    protected void validatePage(MultiStatus multiStatus) {
        if (!StringUtility.hasText((CharSequence)this.getDirective())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", Texts.get("Name"))));
        } else if (!this.getDirective().equals("b") && this.m_illegalNames.contains(this.getDirective())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("DirectiveXMustBeUnique", this.getDirective())));
        }
    }

    public void setDirective(String directive) {
        try {
            this.setStateChanging(true);
            this.setDirectiveInternal(directive);
            if (this.isControlCreated()) {
                this.m_directiveField.setText(directive);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setDirectiveInternal(String directive) {
        this.m_propertySupport.setPropertyString(PROP_DIRECTIVE, directive);
    }

    public String getDirective() {
        return this.m_propertySupport.getPropertyString(PROP_DIRECTIVE);
    }

    public void setValue(String value) {
        try {
            this.setStateChanging(true);
            this.setValueInternal(value);
            if (this.isControlCreated()) {
                this.m_valueField.setText(value);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setValueInternal(String value) {
        this.m_propertySupport.setPropertyString(PROP_VALUE, value);
    }

    public String getValue() {
        return this.m_propertySupport.getPropertyString(PROP_VALUE);
    }

    public Set<String> getIllegalNames() {
        return this.m_illegalNames;
    }

    public void setIllegalNames(Set<String> illegalNames) {
        this.m_illegalNames = illegalNames;
    }
}

