/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class Base64Utility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(Base64Utility.class);
    private static final char[] BYTE_TO_CHAR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] CHAR_TO_BYTE;

    static {
        int[] charToByte = new int[128];
        int i = 0;
        while (i < BYTE_TO_CHAR.length) {
            charToByte[Base64Utility.BYTE_TO_CHAR[i]] = i;
            ++i;
        }
        CHAR_TO_BYTE = charToByte;
    }

    private Base64Utility() {
    }

    public static String encode(byte[] bytes) {
        int block;
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder((int)Math.ceil((double)length / 3.0) * 4);
        int remainder = length % 3;
        length -= remainder;
        int i = 0;
        while (i < length) {
            block = (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
            buffer.append(BYTE_TO_CHAR[block >>> 18]);
            buffer.append(BYTE_TO_CHAR[block >>> 12 & 0x3F]);
            buffer.append(BYTE_TO_CHAR[block >>> 6 & 0x3F]);
            buffer.append(BYTE_TO_CHAR[block & 0x3F]);
        }
        if (remainder == 0) {
            return buffer.toString();
        }
        if (remainder == 1) {
            block = (bytes[i] & 0xFF) << 4;
            buffer.append(BYTE_TO_CHAR[block >>> 6]);
            buffer.append(BYTE_TO_CHAR[block & 0x3F]);
            buffer.append("==");
            return buffer.toString();
        }
        block = ((bytes[i++] & 0xFF) << 8 | bytes[i] & 0xFF) << 2;
        buffer.append(BYTE_TO_CHAR[block >>> 12]);
        buffer.append(BYTE_TO_CHAR[block >>> 6 & 0x3F]);
        buffer.append(BYTE_TO_CHAR[block & 0x3F]);
        buffer.append("=");
        return buffer.toString();
    }

    public static byte[] decode(String string) {
        int length;
        int n = length = string == null ? 0 : string.length();
        if (length == 0) {
            return new byte[0];
        }
        P_Base64InputStream is = new P_Base64InputStream(string);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            try {
                int c1 = is.read();
                int c2 = is.read();
                int c3 = is.read();
                int c4 = is.read();
                while (c1 >= 0 || c2 >= 0 || c3 >= 0 || c4 >= 0) {
                    int block = ((c1 != -1 ? CHAR_TO_BYTE[c1] : -1) & 0xFF) << 18 | ((c2 != -1 ? CHAR_TO_BYTE[c2] : -1) & 0xFF) << 12 | ((c3 != -1 ? CHAR_TO_BYTE[c3] : -1) & 0xFF) << 6 | (c4 != -1 ? CHAR_TO_BYTE[c4] : -1) & 0xFF;
                    buffer.write((byte)(block >>> 16));
                    if (c3 != -1) {
                        buffer.write((byte)(block >>> 8 & 0xFF));
                    }
                    if (c4 != -1) {
                        buffer.write((byte)(block & 0xFF));
                    }
                    c1 = is.read();
                    c2 = is.read();
                    c3 = is.read();
                    c4 = is.read();
                }
            }
            catch (IOException e) {
                LOG.error("IOException in Base64Utility.decode()", e);
                byte[] byArray = new byte[]{};
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    LOG.warn("P_Base64InputStream couldn't be closed.", e2);
                }
                return byArray;
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                LOG.warn("P_Base64InputStream couldn't be closed.", e);
            }
        }
        return buffer.toByteArray();
    }

    private static class P_Base64InputStream
    extends InputStream {
        private final String m_buffer;
        private final int m_count;
        private int m_pos = 0;

        public P_Base64InputStream(String base64String) {
            this.m_buffer = base64String;
            this.m_count = base64String.length();
        }

        @Override
        public int read() throws IOException {
            while (this.m_pos < this.m_count) {
                char ch;
                if (!((ch = this.m_buffer.charAt(this.m_pos++)) >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '+') && ch != '/') continue;
                return ch & 0xFF;
            }
            return -1;
        }
    }
}

