/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.runtime;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClasspathBrowser {
    private static final boolean DEBUG_PATH = false;
    private static final boolean DEBUG_ENTRY = false;
    private ArrayList<String> m_classpathsList = new ArrayList();
    private Set<String> m_classes = new TreeSet<String>();
    private Set<String> m_resources = new TreeSet<String>();

    public void addDefaultClasspaths() {
        this.addClasspath(System.getProperty("sun.boot.class.path"));
        this.addClasspath(System.getProperty("java.class.path"));
    }

    public void addClasspath(String cp) {
        this.m_classpathsList.add(cp);
    }

    /*
     * Unable to fully structure code
     */
    public void addClasspathsByClassLoader(Class startClass) {
        cl = startClass.getClassLoader();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                a = ((URLClassLoader)cl).getURLs();
                if (a != null) {
                    var7_9 = a;
                    var6_8 = a.length;
                    var5_6 = 0;
                    while (var5_6 < var6_8) {
                        url = var7_9[var5_6];
                        this.m_classpathsList.add(url.getFile());
                        ++var5_6;
                    }
                }
            } else {
                try {
                    m = cl.getClass().getMethod("getPaths", new Class[0]);
                    b = (String[])m.invoke((Object)cl, new Object[0]);
                    if (b == null) ** GOTO lbl33
                    var8_11 = b;
                    var7_10 = b.length;
                    var6_8 = 0;
                    while (var6_8 < var7_10) {
                        path = var8_11[var6_8];
                        this.m_classpathsList.add(path);
                        ++var6_8;
                    }
                }
                catch (Exception var3_4) {
                    // empty catch block
                }
            }
lbl33:
            // 4 sources

            cl = cl.getParent();
        }
    }

    public void visit() throws Exception {
        this.m_classes.clear();
        this.m_resources.clear();
        for (String s : this.m_classpathsList) {
            this.visitClasspaths(s);
        }
    }

    public String[] getClasses() {
        return this.m_classes.toArray(new String[0]);
    }

    public String[] getResources() {
        return this.m_resources.toArray(new String[0]);
    }

    private void visitClasspaths(String classpaths) throws Exception {
        String[] a;
        String[] stringArray = a = classpaths.split(File.pathSeparator);
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String cp = stringArray[n2];
            this.visitClasspath(cp);
            ++n2;
        }
    }

    private void visitClasspath(String classpath) throws Exception {
        File f = new File(classpath.trim());
        if (f.isDirectory()) {
            String dirName = f.getCanonicalPath();
            int dirNameLen = dirName.length();
            if (!dirName.endsWith("/") && !dirName.endsWith("\\")) {
                ++dirNameLen;
            }
            this.visitDirectory(dirNameLen, f);
        } else if (f.exists()) {
            this.visitJar(f);
        }
    }

    private void visitJar(File f) throws Exception {
        try (JarFile jarFile = null;){
            jarFile = new JarFile(f);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                if (entry.isDirectory()) continue;
                String entryName = entry.getName();
                this.visitEntry(entryName);
            }
        }
    }

    private void visitDirectory(int namePrefixLen, File dir) throws Exception {
        File[] files = dir.listFiles();
        if (files != null) {
            int n = files.length;
            int i = 0;
            while (i < n) {
                if (files[i].isDirectory()) {
                    this.visitDirectory(namePrefixLen, files[i]);
                } else {
                    String fileName = files[i].getCanonicalPath();
                    String entryName = fileName.substring(namePrefixLen);
                    this.visitEntry(entryName);
                }
                ++i;
            }
        }
    }

    private void visitEntry(String entryName) throws Exception {
        if (entryName.endsWith(".class")) {
            String className = entryName.substring(0, entryName.length() - 6);
            if (this.acceptClass(className = className.replaceAll("[/\\\\]", "."))) {
                this.m_classes.add(className);
            }
        } else {
            String resName = entryName;
            String resPath = "";
            int i = (resName = resName.replace('\\', '/')).lastIndexOf(47);
            if (i >= 0) {
                resPath = resName.substring(0, i + 1);
                resName = resName.substring(i + 1);
            }
            if (!resPath.startsWith("/")) {
                resPath = "/" + resPath;
            }
            if (this.acceptResoure(resPath, resName)) {
                this.m_resources.add(String.valueOf(resPath) + resName);
            }
        }
    }

    protected boolean acceptClass(String className) {
        if (className.indexOf(36) >= 0) {
            return false;
        }
        if (className.startsWith("java.")) {
            return false;
        }
        if (className.startsWith("javax.")) {
            return false;
        }
        if (className.startsWith("com.sun.")) {
            return false;
        }
        if (className.startsWith("sun.")) {
            return false;
        }
        if (className.startsWith("sunw.")) {
            return false;
        }
        if (className.startsWith("org.")) {
            return false;
        }
        if (className.startsWith("oracle.")) {
            return false;
        }
        if (className.startsWith("com.thoughtworks.")) {
            return false;
        }
        if (className.startsWith("com.ibm.")) {
            return false;
        }
        if (className.startsWith("com.tivoli.")) {
            return false;
        }
        if (className.startsWith("net.sf.retrotranslator.")) {
            return false;
        }
        return !className.startsWith("WEB-INF.classes.");
    }

    protected boolean acceptResoure(String path, String name) {
        if (path.startsWith("/java/")) {
            return false;
        }
        if (path.startsWith("/sun/")) {
            return false;
        }
        if (path.startsWith("/com/sun/")) {
            return false;
        }
        if (path.startsWith("/javax/")) {
            return false;
        }
        if (path.startsWith("/java/")) {
            return false;
        }
        if (path.startsWith("/org/")) {
            return false;
        }
        if (path.startsWith("/oracle/")) {
            return false;
        }
        if (path.startsWith("/com/ibm/")) {
            return false;
        }
        if (path.startsWith("/com/tivoli/")) {
            return false;
        }
        if (path.startsWith("/net/sf/retrotranslator/")) {
            return false;
        }
        return !path.startsWith("/WEB-INF/classes/");
    }

    private void log(String s) {
        System.out.println(s);
    }
}

