/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.view;

import java.security.Permission;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceEvent;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceListener;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.AbstractBookmarkTreeField;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.IBookmarkForm;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractLinkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.security.CreateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.DeleteUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkChangedClientNotification;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class BookmarkViewForm
extends AbstractForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BookmarkViewForm.class);

    @ConfigProperty(value="FORM")
    @Order(value=10.0)
    protected Class<? extends IBookmarkForm> getConfiguredBookmarkForm() {
        return BookmarkForm.class;
    }

    @Override
    protected String getConfiguredTitle() {
        return ScoutTexts.get((String)"Bookmarks", (String[])new String[0]);
    }

    public void startView() throws ProcessingException {
        this.startInternal(new ViewHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.TabBox.BookmarksBox getBookmarksBox() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.class);
    }

    public MainBox.TabBox.BookmarksBox.UserBookmarkTreeField getUserBookmarkTreeField() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.UserBookmarkTreeField.class);
    }

    public MainBox.TabBox.BookmarksBox.UserBookmarkSearchField getUserBookmarkSearchField() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.UserBookmarkSearchField.class);
    }

    public MainBox.TabBox.BookmarksBox.AddBookmarksLinkButton getOkButton() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.AddBookmarksLinkButton.class);
    }

    public MainBox.TabBox.BookmarksBox.SetStartPageLinkButton getSetStartPageLinkButton() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.SetStartPageLinkButton.class);
    }

    public MainBox.TabBox.BookmarksBox.ClearStartPageLinkButton getClearStartPageLinkButton() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.ClearStartPageLinkButton.class);
    }

    private void refreshFormState() {
        IBookmarkService bmService = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
        this.getUserBookmarkTreeField().setBookmarkRootFolder(bmService.getBookmarkData().getUserBookmarks());
        this.getUserBookmarkTreeField().populateTree();
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {

        @Order(value=10.0)
        public class TabBox
        extends AbstractTabBox {

            @Order(value=10.0)
            public class BookmarksBox
            extends AbstractGroupBox {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"Bookmarks", (String[])new String[0]);
                }

                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Order(value=100.0)
                public class AddBookmarksLinkButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"BookmarksAddMenu", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() throws ProcessingException {
                        this.setVisiblePermission((Permission)new CreateUserBookmarkPermission());
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        int kind = 1;
                        Bookmark b = ClientSyncJob.getCurrentSession().getDesktop().createBookmark();
                        if (b != null) {
                            b.setKind(kind);
                            IBookmarkForm form = null;
                            if (BookmarkViewForm.this.getConfiguredBookmarkForm() != null) {
                                try {
                                    form = BookmarkViewForm.this.getConfiguredBookmarkForm().newInstance();
                                }
                                catch (Exception e) {
                                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + BookmarkViewForm.this.getConfiguredBookmarkForm().getName() + "'.", (Throwable)e));
                                }
                            }
                            if (form == null) {
                                form = new BookmarkForm();
                            }
                            form.setBookmarkRootFolder(BookmarkViewForm.this.getUserBookmarkTreeField().getBookmarkRootFolder());
                            form.setBookmark(b);
                            if (form.getBookmarkRootFolder() != form.getBookmarkRootFolder()) {
                                form.setFolder(form.getBookmarkRootFolder());
                            }
                            form.startNew();
                            form.waitFor();
                            if (form.isFormStored()) {
                                b.setTitle(b.getTitle());
                                b.setKeyStroke(b.getKeyStroke());
                                BookmarkFolder folder = form.getFolder();
                                if (folder == null) {
                                    folder = form.getBookmarkRootFolder();
                                }
                                folder.getBookmarks().add(b);
                                IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
                                service.storeBookmarks();
                            }
                        }
                    }
                }

                @Order(value=120.0)
                public class ClearStartPageLinkButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"BookmarksStartPageMenuClear", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() throws ProcessingException {
                        this.setVisiblePermission((Permission)new CreateUserBookmarkPermission());
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
                        service.deleteStartBookmark();
                        service.storeBookmarks();
                    }
                }

                @Order(value=110.0)
                public class SetStartPageLinkButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"BookmarksStartPageMenuSet", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() throws ProcessingException {
                        this.setVisiblePermission((Permission)new CreateUserBookmarkPermission());
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
                        service.setStartBookmark();
                        service.storeBookmarks();
                    }
                }

                @Order(value=20.0)
                public class UserBookmarkSearchField
                extends AbstractStringField
                implements ITreeNodeFilter {
                    private Pattern m_lowercaseFilterPattern;

                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"FilterBookmarkTree", (String[])new String[0]);
                    }

                    @Override
                    protected String getConfiguredTooltipText() {
                        return ScoutTexts.get((String)"SmartFindLabel", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredLabelVisible() {
                        return false;
                    }

                    @Override
                    protected int getConfiguredLabelPosition() {
                        return 2;
                    }

                    @Override
                    protected boolean getConfiguredUpdateDisplayTextOnModify() {
                        return true;
                    }

                    @Override
                    protected void execChangedDisplayText() {
                        String s = StringUtility.emptyIfNull((Object)this.getDisplayText()).trim();
                        if (s.length() > 0) {
                            if (!s.endsWith("*")) {
                                s = String.valueOf(s) + "*";
                            }
                            this.m_lowercaseFilterPattern = Pattern.compile(StringUtility.toRegExPattern((String)s.toLowerCase()));
                            BookmarkViewForm.this.getUserBookmarkTreeField().getTree().addNodeFilter(this);
                        } else {
                            BookmarkViewForm.this.getUserBookmarkTreeField().getTree().removeNodeFilter(this);
                        }
                    }

                    @Override
                    public boolean accept(ITreeNode node, int level) {
                        String text = node.getCell().getText();
                        return text == null || this.m_lowercaseFilterPattern == null || this.m_lowercaseFilterPattern.matcher(text.toLowerCase()).matches();
                    }
                }

                @Order(value=20.0)
                public class UserBookmarkTreeField
                extends AbstractBookmarkTreeField {
                    @Override
                    protected int getConfiguredGridW() {
                        return 1;
                    }

                    @Override
                    protected int getConfiguredGridH() {
                        return 10;
                    }

                    @Override
                    protected Permission getDeletePermission() {
                        return new DeleteUserBookmarkPermission();
                    }

                    @Override
                    protected Permission getUpdatePermission() {
                        return new UpdateUserBookmarkPermission();
                    }
                }
            }
        }
    }

    @Order(value=20.0)
    public class ViewHandler
    extends AbstractFormHandler {
        private final IClientNotificationConsumerListener m_cncListener = new IClientNotificationConsumerListener(){

            @Override
            public void handleEvent(ClientNotificationConsumerEvent e, boolean sync) {
                if (e.getClientNotification() instanceof BookmarkChangedClientNotification) {
                    new ClientSyncJob("Bookmarks changed", ClientSyncJob.getCurrentSession()){

                        @Override
                        protected void runVoid(IProgressMonitor monitor) throws Throwable {
                            ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).loadBookmarks();
                        }
                    }.schedule();
                }
            }
        };
        private final BookmarkServiceListener m_bmListener = new BookmarkServiceListener(){

            @Override
            public void bookmarksChanged(BookmarkServiceEvent e) {
                switch (e.getType()) {
                    case 10: {
                        BookmarkViewForm.this.refreshFormState();
                    }
                }
            }
        };

        @Override
        protected void execLoad() throws ProcessingException {
            IBookmarkService bmService;
            IClientNotificationConsumerService cncService = (IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class);
            if (cncService != null) {
                cncService.removeClientNotificationConsumerListener(ClientSyncJob.getCurrentSession(), this.m_cncListener);
                cncService.addClientNotificationConsumerListener(ClientSyncJob.getCurrentSession(), this.m_cncListener);
            }
            if ((bmService = (IBookmarkService)SERVICES.getService(IBookmarkService.class)) != null) {
                bmService.removeBookmarkServiceListener(this.m_bmListener);
                bmService.addBookmarkServiceListener(this.m_bmListener);
                bmService.loadBookmarks();
            }
        }

        @Override
        protected void execFinally() throws ProcessingException {
            IBookmarkService bmService = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
            IClientNotificationConsumerService cncService = (IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class);
            if (bmService != null) {
                bmService.removeBookmarkServiceListener(this.m_bmListener);
            }
            if (cncService != null) {
                cncService.removeClientNotificationConsumerListener(ClientSyncJob.getCurrentSession(), this.m_cncListener);
            }
        }
    }
}

