/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.browserfield;

import java.net.URL;
import java.util.List;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.browserfield.BrowserFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.browserfield.IBrowserFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserFieldUIFacade;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

@ClassId(value="6402e68c-abd1-42b8-8da2-b4a12f910c98")
public abstract class AbstractBrowserField
extends AbstractValueField<RemoteFile>
implements IBrowserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBrowserField.class);
    private IBrowserFieldUIFacade m_uiFacade;
    private boolean m_scrollBarEnabled;

    public AbstractBrowserField() {
        this(true);
    }

    public AbstractBrowserField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected boolean execAcceptLocationChange(String location, String path, boolean local) throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execLocationChanged(String location, String path, boolean local) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.m_scrollBarEnabled = this.getConfiguredScrollBarEnabled();
    }

    @Override
    protected void applySearchInternal(SearchFilter search) {
    }

    @Override
    public void doLocationChange(String location) throws ProcessingException {
        if (this.getUIFacade().fireBeforeLocationChangedFromUI(location)) {
            this.getUIFacade().fireAfterLocationChangedFromUI(location);
        }
    }

    @Override
    public void setLocation(String location) {
        this.propertySupport.setProperty("location", (Object)location);
    }

    @Override
    public String getLocation() {
        return (String)this.propertySupport.getProperty("location");
    }

    @Override
    public IBrowserFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.m_scrollBarEnabled;
    }

    protected final void interceptLocationChanged(String location, String path, boolean local) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        BrowserFieldChains.BrowserFieldLocationChangedChain chain = new BrowserFieldChains.BrowserFieldLocationChangedChain(extensions);
        chain.execLocationChanged(location, path, local);
    }

    protected final boolean interceptAcceptLocationChange(String location, String path, boolean local) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        BrowserFieldChains.BrowserFieldAcceptLocationChangeChain chain = new BrowserFieldChains.BrowserFieldAcceptLocationChangeChain(extensions);
        return chain.execAcceptLocationChange(location, path, local);
    }

    @Override
    protected IBrowserFieldExtension<? extends AbstractBrowserField> createLocalExtension() {
        return new LocalBrowserFieldExtension<AbstractBrowserField>(this);
    }

    protected static class LocalBrowserFieldExtension<OWNER extends AbstractBrowserField>
    extends AbstractValueField.LocalValueFieldExtension<RemoteFile, OWNER>
    implements IBrowserFieldExtension<OWNER> {
        public LocalBrowserFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execLocationChanged(BrowserFieldChains.BrowserFieldLocationChangedChain chain, String location, String path, boolean local) throws ProcessingException {
            ((AbstractBrowserField)this.getOwner()).execLocationChanged(location, path, local);
        }

        @Override
        public boolean execAcceptLocationChange(BrowserFieldChains.BrowserFieldAcceptLocationChangeChain chain, String location, String path, boolean local) throws ProcessingException {
            return ((AbstractBrowserField)this.getOwner()).execAcceptLocationChange(location, path, local);
        }
    }

    private class P_UIFacade
    implements IBrowserFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean fireBeforeLocationChangedFromUI(String location) {
            try {
                URL url = null;
                try {
                    url = new URL(location);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return AbstractBrowserField.this.interceptAcceptLocationChange(location, url != null ? url.getPath() : null, url != null && "local".equals(url.getHost()));
            }
            catch (Throwable t) {
                LOG.error("location: " + location, t);
                return false;
            }
        }

        @Override
        public void fireAfterLocationChangedFromUI(String location) {
            try {
                URL url = null;
                try {
                    url = new URL(location);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                AbstractBrowserField.this.interceptLocationChanged(location, url != null ? url.getPath() : null, url != null && "local".equals(url.getHost()));
            }
            catch (Throwable t) {
                LOG.error("location: " + location, t);
            }
        }
    }
}

