/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security;

import java.util.Collection;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotification;

public class AccessControlCacheChangedClusterNotification
implements IClusterNotification {
    private static final long serialVersionUID = 128460814967537176L;
    private final Set<String> m_userIds;

    public AccessControlCacheChangedClusterNotification() {
        this(null);
    }

    public AccessControlCacheChangedClusterNotification(Collection<String> userIds) {
        this.m_userIds = CollectionUtility.hashSetWithoutNullElements(userIds);
    }

    public Set<String> getUserIds() {
        return this.m_userIds;
    }

    public String toString() {
        return "AccessControlCacheChangedClusterNotification [m_userIds=" + this.m_userIds + "]";
    }

    @Override
    public boolean coalesce(IClusterNotification existingNotification0) {
        if (existingNotification0 instanceof AccessControlCacheChangedClusterNotification) {
            AccessControlCacheChangedClusterNotification existingNotification = (AccessControlCacheChangedClusterNotification)existingNotification0;
            this.m_userIds.addAll(existingNotification.getUserIds());
            return true;
        }
        return false;
    }
}

