/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.validate.IValidationStrategy;
import org.eclipse.scout.rt.shared.validate.IValidator;
import org.eclipse.scout.rt.shared.validate.ValidateCheckSet;
import org.eclipse.scout.rt.shared.validate.ValidationUtility;
import org.eclipse.scout.rt.shared.validate.annotations.CodeValue;
import org.eclipse.scout.rt.shared.validate.annotations.LookupValue;
import org.eclipse.scout.rt.shared.validate.annotations.Mandatory;
import org.eclipse.scout.rt.shared.validate.annotations.MaxLength;
import org.eclipse.scout.rt.shared.validate.annotations.MaxValue;
import org.eclipse.scout.rt.shared.validate.annotations.MinLength;
import org.eclipse.scout.rt.shared.validate.annotations.MinValue;
import org.eclipse.scout.rt.shared.validate.annotations.RegexMatch;
import org.eclipse.scout.rt.shared.validate.annotations.Treat0AsNull;
import org.eclipse.scout.rt.shared.validate.checks.CodeValueCheck;
import org.eclipse.scout.rt.shared.validate.checks.LookupValueCheck;
import org.eclipse.scout.rt.shared.validate.checks.MandatoryCheck;
import org.eclipse.scout.rt.shared.validate.checks.MasterValueRequiredCheck;
import org.eclipse.scout.rt.shared.validate.checks.MaxLengthCheck;
import org.eclipse.scout.rt.shared.validate.checks.MaxLengthGenericCheck;
import org.eclipse.scout.rt.shared.validate.checks.MaxValueCheck;
import org.eclipse.scout.rt.shared.validate.checks.MinLengthCheck;
import org.eclipse.scout.rt.shared.validate.checks.MinValueCheck;
import org.eclipse.scout.rt.shared.validate.checks.RegexMatchCheck;

public class DefaultValidator
extends ValidationUtility.ValidateTreeVisitor
implements IValidator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultValidator.class);
    private static final Map<String, Object> NO_RULE_MAP = new HashMap<String, Object>();
    private IValidationStrategy m_validationStrategy;
    private ValidateCheckSet m_defaultCheckSet;
    private HashSet<String> m_consumedChecks = new HashSet();

    public DefaultValidator(IValidationStrategy validationStrategy) {
        this.m_validationStrategy = validationStrategy;
        this.m_defaultCheckSet = new ValidateCheckSet();
    }

    @Override
    public void validateMethodCall(Method m, Object[] parameters) throws Exception {
        if (parameters == null || parameters.length == 0) {
            return;
        }
        this.initDefaultChecks(this.m_defaultCheckSet);
        if (this.m_defaultCheckSet.isEmpty()) {
            this.m_defaultCheckSet = null;
        }
        Collection<Annotation>[] parameterAnnotations = this.collectParameterAnnotations(m);
        int i = 0;
        while (i < parameters.length) {
            this.start(parameters[i], parameterAnnotations[i]);
            ++i;
        }
    }

    @Override
    public void validateParameter(Object parameter, Collection<Annotation> parameterAnnotations) throws Exception {
        this.initDefaultChecks(this.m_defaultCheckSet);
        if (this.m_defaultCheckSet.isEmpty()) {
            this.m_defaultCheckSet = null;
        }
        this.start(parameter, parameterAnnotations);
    }

    protected void initDefaultChecks(ValidateCheckSet checkSet) {
        checkSet.addCheck(new MaxLengthGenericCheck(250, 64000000, 64000000, 10000));
    }

    protected Collection<Annotation>[] collectParameterAnnotations(Method m) {
        return ValidationUtility.getParameterAnnotations(m);
    }

    protected ValidateCheckSet validateObjectByAnnotations(Collection<Annotation> annotationList, Object obj) throws Exception {
        if (this.isTreat0AsNullFromAnnotations(annotationList)) {
            obj = ValidationUtility.treat0AsNull(obj);
        }
        ValidateCheckSet localSet = new ValidateCheckSet();
        ValidateCheckSet subtreeSet = new ValidateCheckSet();
        this.addChecksFromAnnotations(localSet, subtreeSet, annotationList, obj);
        this.m_consumedChecks.clear();
        if (localSet != null) {
            localSet.applyChecks(this.m_validationStrategy, obj, this.m_consumedChecks);
        }
        if (subtreeSet != null) {
            subtreeSet.applyChecks(this.m_validationStrategy, obj, this.m_consumedChecks);
        }
        if (this.m_defaultCheckSet != null) {
            this.m_defaultCheckSet.applyChecks(this.m_validationStrategy, obj, this.m_consumedChecks);
        }
        return subtreeSet;
    }

    protected boolean isTreat0AsNullFromAnnotations(Collection<Annotation> annotationList) {
        if (annotationList.size() == 0) {
            return false;
        }
        for (Annotation a : annotationList) {
            if (a.annotationType() != Treat0AsNull.class) continue;
            return ((Treat0AsNull)a).value();
        }
        return false;
    }

    protected void addChecksFromAnnotations(ValidateCheckSet localSet, ValidateCheckSet subtreeSet, Collection<Annotation> annotationList, Object value) {
        if (annotationList.size() == 0) {
            return;
        }
        for (Annotation a : annotationList) {
            try {
                this.addCheckFromAnnotation(localSet, subtreeSet, a, value);
            }
            catch (Throwable t) {
                LOG.error("failed creating check implementation for " + a, t);
            }
        }
    }

    protected void addCheckFromAnnotation(ValidateCheckSet localSet, ValidateCheckSet subtreeSet, Annotation a, Object value) throws Exception {
        if (a.annotationType() == CodeValue.class) {
            CodeValue x = (CodeValue)a;
            if (value == null || value.getClass().isArray() && Array.getLength(value) == 0) {
                return;
            }
            (x.subtree() ? subtreeSet : localSet).addCheck(new CodeValueCheck(CODES.getCodeType(x.value())));
        } else if (a.annotationType() == LookupValue.class) {
            LookupValue x = (LookupValue)a;
            if (value == null || value.getClass().isArray() && Array.getLength(value) == 0) {
                return;
            }
            (x.subtree() ? subtreeSet : localSet).addCheck(new LookupValueCheck(x.value().newInstance()));
        } else if (a.annotationType() == Mandatory.class) {
            Mandatory x = (Mandatory)a;
            (x.subtree() ? subtreeSet : localSet).addCheck(new MandatoryCheck(x.value()));
        } else if (a.annotationType() == MinLength.class) {
            MinLength x = (MinLength)a;
            (x.subtree() ? subtreeSet : localSet).addCheck(new MinLengthCheck(x.value()));
        } else if (a.annotationType() == MaxLength.class) {
            MaxLength x = (MaxLength)a;
            (x.subtree() ? subtreeSet : localSet).addCheck(new MaxLengthCheck(x.value()));
        } else if (a.annotationType() == MinValue.class) {
            if (value == null) {
                return;
            }
            MinValue x = (MinValue)a;
            (x.subtree() ? subtreeSet : localSet).addCheck(new MinValueCheck(x.value()));
        } else if (a.annotationType() == MaxValue.class) {
            if (value == null) {
                return;
            }
            MaxValue x = (MaxValue)a;
            (x.subtree() ? subtreeSet : localSet).addCheck(new MaxValueCheck(x.value()));
        } else if (a.annotationType() == RegexMatch.class) {
            if (value == null) {
                return;
            }
            RegexMatch x = (RegexMatch)a;
            (x.subtree() ? subtreeSet : localSet).addCheck(new RegexMatchCheck(x.value()));
        }
    }

    protected void validateFormDataFields(AbstractFormData formData) throws Exception {
        for (Map<String, AbstractFormFieldData> map : formData.getAllFieldsRec().values()) {
            for (AbstractFormFieldData field : map.values()) {
                Map<String, Object> ruleMap;
                if (!field.isValueSet() || (ruleMap = field.getValidationRules()).size() == 0) continue;
                Object fieldValue = null;
                if (field instanceof AbstractValueFieldData) {
                    fieldValue = ((AbstractValueFieldData)field).getValue();
                }
                this.markObject(fieldValue);
                this.validateFormDataFieldByValidationRules(formData, ruleMap, field.getClass().getSimpleName(), fieldValue);
            }
        }
    }

    protected void validateFormDataFieldByValidationRules(AbstractFormData formData, Map<String, Object> ruleMap, String fieldName, Object obj) throws Exception {
        FormDataCheckContext ctx = new FormDataCheckContext();
        ctx.formData = formData;
        ctx.ruleMap = ruleMap;
        ctx.fieldName = fieldName;
        if (this.isTreat0AsNullFromValidationRules(ctx)) {
            obj = ValidationUtility.treat0AsNull(obj);
        }
        ValidateCheckSet localCheckSet = new ValidateCheckSet();
        this.addChecksFromValidationRules(localCheckSet, ctx, obj);
        this.m_consumedChecks.clear();
        if (localCheckSet != null) {
            localCheckSet.applyChecks(this.m_validationStrategy, obj, this.m_consumedChecks);
        }
        if (this.m_defaultCheckSet != null) {
            this.m_defaultCheckSet.applyChecks(this.m_validationStrategy, obj, this.m_consumedChecks);
        }
    }

    protected boolean isTreat0AsNullFromValidationRules(FormDataCheckContext ctx) {
        return Boolean.TRUE.equals(ctx.ruleMap.get("zeroNullEquality"));
    }

    protected void addChecksFromValidationRules(ValidateCheckSet set, FormDataCheckContext ctx, Object value) {
        if (ctx.ruleMap == null || ctx.ruleMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> e : ctx.ruleMap.entrySet()) {
            if (e.getKey() == null) continue;
            ctx.ruleName = e.getKey();
            ctx.ruleValue = e.getValue();
            try {
                this.addCheckFromValidationRule(set, ctx, value);
            }
            catch (Throwable t) {
                LOG.error("failed creating check implementation for " + ctx.ruleName + "=" + ctx.ruleValue, t);
            }
        }
    }

    protected void addCheckFromValidationRule(ValidateCheckSet set, FormDataCheckContext ctx, Object value) throws Exception {
        String key = ctx.ruleName;
        if (key.equals("codeType")) {
            if (value == null || value.getClass().isArray() && Array.getLength(value) == 0) {
                return;
            }
            set.addCheck(new CodeValueCheck(this.createCodeTypeByValidationRules(ctx)));
        } else if (key.equals("lookupCall")) {
            if (value == null || value.getClass().isArray() && Array.getLength(value) == 0) {
                return;
            }
            set.addCheck(new LookupValueCheck(this.createLookupCallByValidationRules(ctx)));
        } else if (key.equals("mandatory")) {
            if (!Boolean.TRUE.equals(ctx.ruleValue)) {
                return;
            }
            set.addCheck(new MandatoryCheck(true));
        } else if (key.equals("minLength")) {
            set.addCheck(new MinLengthCheck(((Number)ctx.ruleValue).intValue()));
        } else if (key.equals("maxLength")) {
            set.addCheck(new MaxLengthCheck(((Number)ctx.ruleValue).intValue()));
        } else if (key.equals("minValue")) {
            if (value == null) {
                return;
            }
            set.addCheck(new MinValueCheck(ctx.ruleValue));
        } else if (key.equals("maxValue")) {
            if (value == null) {
                return;
            }
            set.addCheck(new MaxValueCheck(ctx.ruleValue));
        } else if (key.equals("regex")) {
            if (value == null) {
                return;
            }
            set.addCheck(new RegexMatchCheck((String)ctx.ruleValue));
        } else if (key.equals("masterValueRequired")) {
            if (value == null || value.getClass().isArray() && Array.getLength(value) == 0) {
                return;
            }
            if (!Boolean.TRUE.equals(ctx.ruleMap.get("masterValueRequired"))) {
                return;
            }
            set.addCheck(new MasterValueRequiredCheck(ctx));
        }
    }

    protected ICodeType<?, ?> createCodeTypeByValidationRules(FormDataCheckContext ctx) throws Exception {
        Class cls = (Class)ctx.ruleValue;
        Object codeType = CODES.getCodeType(cls);
        if (codeType == null) {
            throw new ProcessingException(String.valueOf(ctx.fieldName) + " codeType " + cls.getSimpleName() + " does not exist");
        }
        return codeType;
    }

    protected LookupCall createLookupCallByValidationRules(FormDataCheckContext ctx) throws Exception {
        LookupCall call;
        Class cls = (Class)ctx.ruleValue;
        try {
            call = (LookupCall)cls.newInstance();
        }
        catch (Throwable t) {
            throw new ProcessingException(String.valueOf(ctx.fieldName) + " can not verify " + cls.getSimpleName());
        }
        if (ctx.ruleMap.containsKey("masterValueField")) {
            Class masterFieldClass = (Class)ctx.ruleMap.get("masterValueField");
            if (masterFieldClass == null) {
                throw new ProcessingException(String.valueOf(ctx.fieldName) + " missing master field");
            }
            AbstractValueFieldData masterField = (AbstractValueFieldData)ctx.formData.getFieldByClass(masterFieldClass);
            if (masterField == null) {
                throw new ProcessingException(String.valueOf(ctx.fieldName) + " missing master field " + masterFieldClass.getSimpleName());
            }
            call.setMaster(masterField.getValue());
        }
        return call;
    }

    @Override
    protected void visitObject(Object obj, Collection<Annotation> annotationList) throws Exception {
        ValidateCheckSet additionalSubtreeSet = null;
        if (obj instanceof AbstractFormData) {
            this.validateFormDataFields((AbstractFormData)obj);
        } else {
            additionalSubtreeSet = this.validateObjectByAnnotations(annotationList, obj);
            if (additionalSubtreeSet.isEmpty()) {
                additionalSubtreeSet = null;
            }
        }
        if (additionalSubtreeSet != null) {
            ValidateCheckSet oldSet = this.m_defaultCheckSet;
            try {
                this.m_defaultCheckSet = additionalSubtreeSet;
                additionalSubtreeSet.setParent(oldSet);
                this.visitSubTree(obj);
            }
            finally {
                this.m_defaultCheckSet = oldSet;
            }
        } else {
            this.visitSubTree(obj);
        }
    }

    public static class FormDataCheckContext {
        public AbstractFormData formData;
        public String fieldName;
        public Map<String, Object> ruleMap;
        public String ruleName;
        public Object ruleValue;
    }
}

