/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.action;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.mobile.MobileScoutFormToolkit;
import org.eclipse.scout.rt.ui.rap.mobile.action.ActionButtonBar;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.ScoutFormToolkit;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutActionBar;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractRwtScoutActionBar<T extends IPropertyObserver>
extends RwtScoutComposite<T>
implements IRwtScoutActionBar<T> {
    private static final String VARIANT_ACTION_BAR_CONTAINER = "actionBarContainer";
    private Composite m_leftContainer;
    private ActionButtonBar m_leftButtonBar;
    private Composite m_centerContainer;
    private Composite m_rightContainer;
    private ActionButtonBar m_rightButtonBar;
    private boolean m_alwaysVisible = false;
    private Integer m_heightHint;
    private int m_menuOpeningDirection = 1024;
    private int m_rightActionBarOrientation = 0x2000000;
    private CLabel m_titleField;

    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        container.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getActionBarContainerVariant());
        this.setUiContainer(container);
        this.createContent();
    }

    protected void createContent() {
        this.m_leftContainer = this.createLeftContainer(this.getUiContainer());
        this.m_centerContainer = this.createCenterContainer(this.getUiContainer());
        this.m_rightContainer = this.createRightContainer(this.getUiContainer());
        this.initLayout(this.getUiContainer());
        this.computeContainerVisibility();
    }

    private void computeContainerVisibility() {
        if (this.m_leftContainer == null || this.m_centerContainer == null || this.m_rightContainer == null) {
            this.getUiContainer().setVisible(false);
            return;
        }
        boolean makeInvisible = !this.isAlwaysVisible() && !this.hasContentOnLeftContainer() && !this.hasContentOnCenterContainer() && !this.hasContentOnRightContainer();
        this.getUiContainer().setVisible(!makeInvisible);
    }

    protected void initLayout(Composite container) {
        GridLayout containerLayout = RwtLayoutUtility.createGridLayoutNoSpacing((int)3, (boolean)false);
        container.setLayout((Layout)containerLayout);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        this.m_leftContainer.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, true);
        this.m_centerContainer.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, true);
        this.m_rightContainer.setLayoutData((Object)gridData);
        this.adjustGridDataBasedOnTitle();
    }

    protected String getActionBarContainerVariant() {
        return VARIANT_ACTION_BAR_CONTAINER;
    }

    protected Composite createLeftContainer(Composite parent) {
        this.m_leftButtonBar = this.createLeftActionButtonBar(parent, this.m_leftButtonBar);
        return this.m_leftButtonBar;
    }

    protected boolean hasContentOnLeftContainer() {
        if (this.m_leftButtonBar == null) {
            return false;
        }
        return this.m_leftButtonBar.hasButtons();
    }

    protected ActionButtonBar createLeftActionButtonBar(Composite parent, ActionButtonBar existingButtonBar) {
        LinkedList<IMenu> menuList = new LinkedList<IMenu>();
        this.collectMenusForLeftButtonBar(menuList);
        ActionButtonBar leftButtonBar = this.createActionButtonBar(parent, existingButtonBar, menuList, 0x4000 | this.getMenuOpeningDirection());
        this.adaptLeftButtonBar(leftButtonBar);
        return leftButtonBar;
    }

    protected void adaptLeftButtonBar(ActionButtonBar buttonBar) {
    }

    protected Composite createCenterContainer(Composite parent) {
        return this.createCenterTitleBar(parent, this.m_centerContainer);
    }

    protected boolean hasContentOnCenterContainer() {
        return this.getTitle() != null;
    }

    protected Composite createCenterTitleBar(Composite parent, Composite existingTitleBar) {
        Composite centerTitleBar = this.createTitleBar(parent, existingTitleBar);
        this.adaptCenterTitleBar(centerTitleBar);
        return centerTitleBar;
    }

    protected void adaptCenterTitleBar(Composite buttonBar) {
    }

    protected Composite createRightContainer(Composite parent) {
        this.m_rightButtonBar = this.createRightActionButtonBar(parent, this.m_rightButtonBar);
        return this.m_rightButtonBar;
    }

    protected ActionButtonBar createRightActionButtonBar(Composite parent, ActionButtonBar existingButtonBar) {
        LinkedList<IMenu> menuList = new LinkedList<IMenu>();
        this.collectMenusForRightButtonBar(menuList);
        ActionButtonBar rightButtonBar = this.createActionButtonBar(parent, existingButtonBar, menuList, 0x20000 | this.getMenuOpeningDirection() | this.getRightActionBarOrientation());
        this.adaptRightButtonBar(rightButtonBar);
        return rightButtonBar;
    }

    protected boolean hasContentOnRightContainer() {
        if (this.m_rightButtonBar == null) {
            return false;
        }
        return this.m_rightButtonBar.hasButtons();
    }

    protected void adaptRightButtonBar(ActionButtonBar buttonBar) {
    }

    private Composite createTitleBar(Composite parent, Composite existingTitleBar) {
        if (existingTitleBar != null) {
            existingTitleBar.dispose();
            existingTitleBar = null;
        }
        return this.createTitleBar(parent);
    }

    protected Composite createTitleBar(Composite parent) {
        this.m_titleField = this.getUiEnvironment().getFormToolkit().createCLabel(parent, null, 0x1000000);
        this.m_titleField.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getActionBarContainerVariant());
        return this.m_titleField;
    }

    private ActionButtonBar createActionButtonBar(Composite parent, ActionButtonBar existingButtonBar, List<IMenu> menuList, int style) {
        if (existingButtonBar != null) {
            existingButtonBar.dispose();
            existingButtonBar = null;
        }
        return this.createActionButtonBar(parent, menuList, style);
    }

    protected ActionButtonBar createActionButtonBar(Composite parent, List<IMenu> menus, int style) {
        ScoutFormToolkit formToolkit = this.getUiEnvironment().getFormToolkit();
        if (formToolkit instanceof MobileScoutFormToolkit) {
            IMenu[] menuArray = this.cleanMenus(menus);
            return ((MobileScoutFormToolkit)formToolkit).createActionButtonBar(parent, menuArray, style);
        }
        return null;
    }

    protected IMenu[] cleanMenus(List<IMenu> menus) {
        LinkedList<IMenu> cleanedMenus = new LinkedList<IMenu>();
        for (IMenu menu : menus) {
            if (cleanedMenus.contains(menu)) continue;
            cleanedMenus.add(menu);
        }
        return cleanedMenus.toArray(new IMenu[cleanedMenus.size()]);
    }

    public void rebuildContentFromScout() {
        if (this.isUiDisposed()) {
            return;
        }
        Runnable job = new Runnable(){

            @Override
            public void run() {
                if (AbstractRwtScoutActionBar.this.isUiDisposed()) {
                    return;
                }
                AbstractRwtScoutActionBar.this.createContent();
                AbstractRwtScoutActionBar.this.getUiContainer().getParent().layout(true, true);
            }
        };
        this.getUiEnvironment().invokeUiLater(job);
    }

    protected void setTitle(String title) {
        if (title == null) {
            return;
        }
        if (this.getTitleField() != null) {
            this.getTitleField().setText(title);
        }
        this.adjustGridDataBasedOnTitle();
    }

    protected void adjustGridDataBasedOnTitle() {
        boolean hasTitle = this.getTitle() != null;
        ((GridData)this.m_leftContainer.getLayoutData()).grabExcessHorizontalSpace = !hasTitle;
        ((GridData)this.m_centerContainer.getLayoutData()).exclude = !hasTitle;
        ((GridData)this.m_rightContainer.getLayoutData()).grabExcessHorizontalSpace = !hasTitle;
    }

    public String getTitle() {
        if (this.getTitleField() == null) {
            return null;
        }
        return this.getTitleField().getText();
    }

    public boolean isAlwaysVisible() {
        return this.m_alwaysVisible;
    }

    public void setAlwaysVisible(boolean alwaysVisible) {
        this.m_alwaysVisible = alwaysVisible;
    }

    public Integer getHeightHint() {
        return this.m_heightHint;
    }

    public void setHeightHint(Integer heightHint) {
        this.m_heightHint = heightHint;
    }

    public int getMenuOpeningDirection() {
        return this.m_menuOpeningDirection;
    }

    public void setMenuOpeningDirection(int menuOpeningDirection) {
        this.m_menuOpeningDirection = menuOpeningDirection;
    }

    public int getRightActionBarOrientation() {
        return this.m_rightActionBarOrientation;
    }

    public void setRightActionBarOrientation(int orientation) {
        this.m_rightActionBarOrientation = orientation;
    }

    public CLabel getTitleField() {
        return this.m_titleField;
    }

    protected void collectMenusForLeftButtonBar(List<IMenu> menuList) {
    }

    protected void collectMenusForRightButtonBar(List<IMenu> menuList) {
    }
}

