/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.action;

import java.util.List;
import org.eclipse.rap.rwt.internal.theme.CssBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.internal.theme.WidgetMatcher;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.form.fields.button.SeparatorDummyWidget;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class MenuSizeEstimator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MenuSizeEstimator.class);
    private Rectangle m_menuPadding;
    private Rectangle m_menuItemPadding;
    private int m_menuBorderWidth;
    private Rectangle m_menuItemSeparatorPadding;

    public MenuSizeEstimator(Menu menu) {
        SeparatorDummyWidget separatorDummyWidget = null;
        try {
            try {
                MenuThemeAdapter menuThemeAdapter = new MenuThemeAdapter();
                this.m_menuPadding = menuThemeAdapter.getPadding("Menu", (Widget)menu);
                this.m_menuBorderWidth = menuThemeAdapter.getBorderWidth("Menu", (Widget)menu);
                this.m_menuItemPadding = menuThemeAdapter.getPadding("MenuItem", (Widget)menu);
                separatorDummyWidget = new SeparatorDummyWidget((Widget)menu);
                this.m_menuItemSeparatorPadding = menuThemeAdapter.getPadding("MenuItem", separatorDummyWidget);
            }
            catch (Throwable t) {
                LOG.error("Css properties for menu size estimation could not be loaded", t);
                this.m_menuPadding = new Rectangle(0, 0, 0, 0);
                this.m_menuItemPadding = new Rectangle(0, 0, 0, 0);
                this.m_menuItemSeparatorPadding = new Rectangle(0, 0, 0, 0);
                if (separatorDummyWidget != null) {
                    separatorDummyWidget.dispose();
                }
            }
        }
        finally {
            if (separatorDummyWidget != null) {
                separatorDummyWidget.dispose();
            }
        }
    }

    public int estimateMenuHeight(List<? extends IActionNode> actions) {
        if ((actions = RwtMenuUtility.cleanup(actions)) == null || actions.size() == 0) {
            return 0;
        }
        int height = 0;
        int itemNum = 0;
        for (IActionNode iActionNode : actions) {
            if (iActionNode.isSeparator()) {
                if (itemNum != 0 && itemNum != actions.size() - 1 && !actions.get(itemNum - 1).isSeparator()) {
                    height += this.m_menuItemSeparatorPadding.height + 7;
                }
            } else {
                height += this.m_menuItemPadding.height + 15;
            }
            ++itemNum;
        }
        if (height > 0) {
            height += this.m_menuPadding.height + this.m_menuBorderWidth * 2 + 2;
        }
        return height;
    }

    private class MenuThemeAdapter
    extends ThemeAdapter {
        private MenuThemeAdapter() {
        }

        public Rectangle getPadding(String cssElement, Widget widget) {
            return CssBoxDimensions.createRectangle((CssBoxDimensions)this.getCssBoxDimensions(cssElement, "padding", widget));
        }

        public int getBorderWidth(String cssElement, Widget widget) {
            return this.getCssBorderWidth(cssElement, "border", widget);
        }

        protected void configureMatcher(WidgetMatcher matcher) {
            matcher.addStyle("SEPARATOR", SeparatorDummyWidget.STYLE_SEPARATOR);
        }
    }
}

