/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.dnd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.rap.fileupload.DiskFileUploadReceiver;
import org.eclipse.rap.fileupload.FileDetails;
import org.eclipse.rap.fileupload.FileUploadEvent;
import org.eclipse.rap.fileupload.FileUploadHandler;
import org.eclipse.rap.fileupload.FileUploadListener;
import org.eclipse.rap.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.ClientFile;
import org.eclipse.rap.rwt.client.service.ClientFileUploader;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.scout.rt.ui.rap.dnd.IRwtScoutFileUploadHandler;
import org.eclipse.scout.rt.ui.rap.dnd.RwtScoutFileUploadEvent;
import org.eclipse.scout.rt.ui.rap.dnd.RwtScoutFileUploadFileDetail;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutDndUploadCallback;
import org.eclipse.swt.dnd.DropTargetEvent;

public class RwtScoutFileUploadHandler
implements IRwtScoutFileUploadHandler {
    private final IRwtScoutDndUploadCallback m_uploadCallback;
    private FileUploadHandler m_fileUploadHandler;

    public RwtScoutFileUploadHandler(IRwtScoutDndUploadCallback uploadCallback) {
        this.m_uploadCallback = uploadCallback;
    }

    @Override
    public boolean startFileUpload(DropTargetEvent event) {
        this.m_fileUploadHandler = new FileUploadHandler((FileUploadReceiver)new DiskFileUploadReceiver());
        this.m_fileUploadHandler.addUploadListener((FileUploadListener)new P_UploadListener(event));
        ClientFile[] clientFiles = (ClientFile[])event.data;
        ClientFileUploader uploader = (ClientFileUploader)RWT.getClient().getService(ClientFileUploader.class);
        uploader.submit(this.m_fileUploadHandler.getUploadUrl(), clientFiles);
        return true;
    }

    private static RwtScoutFileUploadEvent createRwtScoutFileUploadEvent(FileUploadEvent event, IRwtScoutFileUploadHandler source) {
        ArrayList<RwtScoutFileUploadFileDetail> uploadDetails = new ArrayList<RwtScoutFileUploadFileDetail>();
        FileDetails[] fileDetailsArray = event.getFileDetails();
        int n = fileDetailsArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileDetails fd = fileDetailsArray[n2];
            uploadDetails.add(new RwtScoutFileUploadFileDetail(fd.getFileName(), fd.getContentType()));
            ++n2;
        }
        return new RwtScoutFileUploadEvent(source, event.getContentLength(), event.getBytesRead(), event.getException(), uploadDetails);
    }

    private class P_UploadListener
    implements FileUploadListener {
        private final ServerPushSession m_pushSession;
        private final DropTargetEvent m_dropTargetEvent;

        public P_UploadListener(DropTargetEvent dropTargetEvent) {
            this.m_dropTargetEvent = dropTargetEvent;
            this.m_pushSession = new ServerPushSession();
            this.m_pushSession.start();
        }

        public void uploadProgress(FileUploadEvent event) {
            RwtScoutFileUploadEvent fileUploadEvent = RwtScoutFileUploadHandler.createRwtScoutFileUploadEvent(event, RwtScoutFileUploadHandler.this);
            RwtScoutFileUploadHandler.this.m_uploadCallback.uploadProgress(this.m_dropTargetEvent, fileUploadEvent);
        }

        public void uploadFinished(FileUploadEvent event) {
            DiskFileUploadReceiver receiver = (DiskFileUploadReceiver)RwtScoutFileUploadHandler.this.m_fileUploadHandler.getReceiver();
            ArrayList<File> uploadedFiles = new ArrayList<File>();
            uploadedFiles.addAll(Arrays.asList(receiver.getTargetFiles()));
            RwtScoutFileUploadEvent fileUploadEvent = RwtScoutFileUploadHandler.createRwtScoutFileUploadEvent(event, RwtScoutFileUploadHandler.this);
            RwtScoutFileUploadHandler.this.m_uploadCallback.uploadFinished(this.m_dropTargetEvent, fileUploadEvent, uploadedFiles);
            this.m_pushSession.stop();
            RwtScoutFileUploadHandler.this.m_fileUploadHandler.removeUploadListener((FileUploadListener)this);
        }

        public void uploadFailed(FileUploadEvent event) {
            RwtScoutFileUploadEvent fileUploadEvent = RwtScoutFileUploadHandler.createRwtScoutFileUploadEvent(event, RwtScoutFileUploadHandler.this);
            RwtScoutFileUploadHandler.this.m_uploadCallback.uploadFailed(this.m_dropTargetEvent, fileUploadEvent);
            this.m_pushSession.stop();
            RwtScoutFileUploadHandler.this.m_fileUploadHandler.removeUploadListener((FileUploadListener)this);
        }
    }
}

