/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.checkbox;

import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.checkbox.IRwtScoutCheckbox;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RwtScoutCheckbox
extends RwtScoutValueFieldComposite<IBooleanField>
implements IRwtScoutCheckbox {
    private P_RwtButtonListener m_uiButtonListener;
    private boolean m_mandatoryCached;
    private StatusLabelEx m_labelPlaceholder;

    @Override
    protected void initializeUi(Composite parent) {
        super.initializeUi(parent);
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.m_labelPlaceholder = new StatusLabelEx(container, 0);
        this.getUiEnvironment().getFormToolkit().getFormToolkit().adapt((Control)this.m_labelPlaceholder, false, false);
        this.m_labelPlaceholder.setLayoutData(LogicalGridDataBuilder.createLabel(((IBooleanField)this.getScoutObject()).getGridData()));
        Button checkbox = this.getUiEnvironment().getFormToolkit().createButton(container, "", 96);
        LogicalGridData checkboxData = LogicalGridDataBuilder.createField(((IBooleanField)this.getScoutObject()).getGridData());
        checkboxData.fillHorizontal = false;
        checkboxData.useUiWidth = true;
        checkboxData.weightx = 0.0;
        checkbox.setLayoutData((Object)checkboxData);
        StatusLabelEx dispatcherLabel = new StatusLabelEx(container, 0);
        dispatcherLabel.setVisible(false);
        this.setUiLabel(dispatcherLabel);
        this.setUiContainer(container);
        this.setUiField((Control)checkbox);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_uiButtonListener == null) {
            this.m_uiButtonListener = new P_RwtButtonListener();
        }
        this.getUiField().addListener(13, (Listener)this.m_uiButtonListener);
    }

    @Override
    protected void setErrorStatusFromScout(IProcessingStatus s) {
        this.m_labelPlaceholder.setStatus(s);
    }

    @Override
    protected void setMandatoryFromScout(boolean b) {
        super.setMandatoryFromScout(b);
        this.updateLabel();
    }

    protected void updateLabel() {
        if (this.getUiLabel() instanceof StatusLabelEx) {
            StatusLabelEx uiLabel = this.getUiLabel();
            if (uiLabel.getText() != null) {
                this.getUiField().setText(uiLabel.getText());
            }
            this.getUiField().setFont(uiLabel.getFont());
            this.getUiField().setForeground(uiLabel.getForeground());
            this.getUiField().setBackground(uiLabel.getBackground());
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        this.getUiField().removeListener(13, (Listener)this.m_uiButtonListener);
    }

    @Override
    public Button getUiField() {
        return (Button)super.getUiField();
    }

    @Override
    public StatusLabelEx getUiLabel() {
        return (StatusLabelEx)super.getUiLabel();
    }

    @Override
    public StatusLabelEx getPlaceholderLabel() {
        return this.m_labelPlaceholder;
    }

    @Override
    protected void setLabelVisibleFromScout() {
        boolean b = ((IBooleanField)this.getScoutObject()).isLabelVisible();
        if (this.m_labelPlaceholder != null && b != this.m_labelPlaceholder.getVisible()) {
            this.m_labelPlaceholder.setVisible(b);
            if (this.getUiContainer() != null && this.isCreated()) {
                this.getUiContainer().layout(true, true);
            }
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        super.setLabelFromScout(s);
        this.updateLabel();
    }

    @Override
    protected void setValueFromScout() {
        this.getUiField().setSelection(BooleanUtility.nvl(this.getScoutObject() == null ? null : (Boolean)((IBooleanField)this.getScoutObject()).getValue()));
    }

    protected void handleUiAction(final boolean selection) {
        if (!this.getUiField().isEnabled()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IBooleanField)RwtScoutCheckbox.this.getScoutObject()).getUIFacade().setSelectedFromUI(selection);
                if (selection != ((IBooleanField)RwtScoutCheckbox.this.getScoutObject()).isChecked()) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            RwtScoutCheckbox.this.getUiField().setSelection(((IBooleanField)RwtScoutCheckbox.this.getScoutObject()).isChecked());
                        }
                    };
                    RwtScoutCheckbox.this.getUiEnvironment().invokeUiLater(r);
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    private class P_RwtButtonListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtButtonListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    RwtScoutCheckbox.this.handleUiAction(RwtScoutCheckbox.this.getUiField().getSelection());
                }
            }
        }
    }
}

