/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.ui.rap.html.IHyperlinkProcessor;

public class HyperlinkParser {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:<a|<area)[ \r\n]+[^>]*href=)([\"'](?!javascript)[^>'\"]*['\"])([^>]*>)", 34);
    private static final Pattern TARGET_PATTERN = Pattern.compile("[ \r\n'\"]+target=['\"]([^\"']*)['\"]", 34);

    public String parse(String html, IHyperlinkProcessor processor) {
        Pattern pattern = LINK_PATTERN;
        Matcher m = pattern.matcher(html);
        StringBuilder buf = new StringBuilder();
        int lastPos = 0;
        while (m.find()) {
            buf.append(html.substring(lastPos, m.start()));
            String url = html.substring(m.start(2) + 1, m.end(2) - 1);
            boolean local = url.contains("http://local/");
            String newLink = html.substring(m.start(1), m.end(1));
            newLink = String.valueOf(newLink) + "\"" + processor.processUrl(url, local) + "\"";
            newLink = String.valueOf(newLink) + html.substring(m.start(3), m.end(3));
            newLink = this.parseTarget(newLink, processor, local);
            buf.append(newLink);
            lastPos = m.end();
        }
        if (lastPos < html.length()) {
            buf.append(html.substring(lastPos));
        }
        return buf.toString();
    }

    protected String parseTarget(String link, IHyperlinkProcessor processor, boolean local) {
        Matcher targetMatcher = TARGET_PATTERN.matcher(link);
        String newLink = link;
        if (targetMatcher.find()) {
            String target = link.substring(targetMatcher.start(1), targetMatcher.end(1));
            String newTarget = processor.processTarget(target, local);
            if (newTarget != null) {
                newLink = link.substring(0, targetMatcher.start(1));
                newLink = String.valueOf(newLink) + newTarget;
                newLink = String.valueOf(newLink) + link.substring(targetMatcher.end(1), link.length());
            }
        } else {
            String newTarget = processor.processTarget(null, local);
            if (newTarget != null) {
                newLink = link.substring(0, link.length() - 1);
                newLink = String.valueOf(newLink) + " target=\"" + newTarget + "\"";
                newLink = String.valueOf(newLink) + link.substring(link.length() - 1, link.length());
            }
        }
        return newLink;
    }
}

