/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.servicetunnel.ServiceTunnelUtility;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeChangedNotification;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.ServiceRegistration;

@Priority(value=-3.0f)
public class CodeServiceClientProxy
extends AbstractService
implements ICodeService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeServiceClientProxy.class);
    private final Object m_stateLock = new Object();
    private final HashMap<CompositeObject, ServiceState> m_stateMap = new HashMap();

    private ServiceState getServiceState() {
        return this.getServiceState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceState getServiceState(Long partitionId) {
        IClientSession session = ClientJob.getCurrentSession();
        if (session == null) {
            LOG.warn("could not find a client session");
            return null;
        }
        if (partitionId == null && session.getSharedVariableMap().containsKey("partitionId")) {
            partitionId = (Long)session.getSharedVariableMap().get("partitionId");
        }
        CompositeObject key = new CompositeObject(new Object[]{session.getClass(), LocaleThreadLocal.get(), partitionId});
        Object object = this.m_stateLock;
        synchronized (object) {
            ServiceState data = this.m_stateMap.get(key);
            if (data == null) {
                data = new ServiceState();
                this.m_stateMap.put(key, data);
            }
            return data;
        }
    }

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        ((IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class)).addGlobalClientNotificationConsumerListener(new IClientNotificationConsumerListener(){

            @Override
            public void handleEvent(final ClientNotificationConsumerEvent e, boolean sync) {
                if (e.getClientNotification().getClass() == CodeTypeChangedNotification.class) {
                    if (sync) {
                        try {
                            CodeServiceClientProxy.this.reloadCodeTypes(((CodeTypeChangedNotification)e.getClientNotification()).getCodeTypes());
                        }
                        catch (Throwable t) {
                            LOG.error("update due to client notification", t);
                        }
                    } else {
                        new ClientSyncJob("Reload code types", ClientSyncJob.getCurrentSession()){

                            @Override
                            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                                CodeServiceClientProxy.this.reloadCodeTypes(((CodeTypeChangedNotification)e.getClientNotification()).getCodeTypes());
                            }
                        }.schedule();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType<?, ?>> T getCodeType(Class<T> type) {
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            ICodeType instance = state.m_cache.get(type);
            if (instance == null && (instance = this.getRemoteService().getCodeType(type)) != null) {
                state.m_cache.put(type, instance);
            }
            return (T)instance;
        }
    }

    public <T extends ICodeType<?, ?>> T getCodeType(Long partitionId, Class<T> type) {
        ICodeType instance = this.getRemoteService().getCodeType(partitionId, type);
        return (T)instance;
    }

    public <T> ICodeType<T, ?> findCodeTypeById(T id) {
        if (id == null) {
            return null;
        }
        ICodeType<T, ?> ct = this.findCodeTypeByIdInternal(id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes("");
        return this.findCodeTypeByIdInternal(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ICodeType<T, ?> findCodeTypeByIdInternal(T id) {
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            for (ICodeType<?, ?> ct : state.m_cache.values()) {
                if (!id.equals(ct.getId())) continue;
                return ct;
            }
        }
        return null;
    }

    public <T> ICodeType<T, ?> findCodeTypeById(Long partitionId, T id) {
        if (id == null) {
            return null;
        }
        ICodeType<T, ?> ct = this.findCodeTypeByIdInternal(partitionId, id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes("");
        return this.findCodeTypeByIdInternal(partitionId, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ICodeType<T, ?> findCodeTypeByIdInternal(Long partitionId, T id) {
        ServiceState state = this.getServiceState(partitionId);
        Object object = state.m_cacheLock;
        synchronized (object) {
            for (ICodeType<?, ?> ct : state.m_cache.values()) {
                if (!id.equals(ct.getId())) continue;
                return ct;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICodeType<?, ?>> getCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        ArrayList missingTypes = new ArrayList();
        ArrayList instances = new ArrayList(types.size());
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            for (Class<ICodeType<?, ?>> clazz : types) {
                ICodeType<?, ?> iCodeType = state.m_cache.get(clazz);
                if (iCodeType != null) {
                    instances.add(iCodeType);
                    continue;
                }
                missingTypes.add(clazz);
            }
            if (missingTypes.size() > 0) {
                List list = this.getRemoteService().getCodeTypes(missingTypes);
                Iterator iNewInstances = list.iterator();
                for (Class clazz : missingTypes) {
                    ICodeType instance;
                    if (!iNewInstances.hasNext() || (instance = (ICodeType)iNewInstances.next()) == null) continue;
                    state.m_cache.put(clazz, instance);
                    instances.add(instance);
                }
            }
        }
        return instances;
    }

    public List<ICodeType<?, ?>> getCodeTypes(Long partitionId, List<Class<? extends ICodeType<?, ?>>> types) {
        return this.getRemoteService().getCodeTypes(partitionId, types);
    }

    private <T> Class<? extends ICodeType<?, T>> getDeclaringCodeTypeClass(Class<? extends ICode<T>> type) {
        if (type == null) {
            return null;
        }
        Class<?> declaringCodeTypeClass = null;
        if (type.getDeclaringClass() != null) {
            Class<?> c = type.getDeclaringClass();
            while (c != null && !ICodeType.class.isAssignableFrom(c)) {
                c = c.getDeclaringClass();
            }
            declaringCodeTypeClass = c;
        }
        if (declaringCodeTypeClass == null) {
            try {
                declaringCodeTypeClass = type.newInstance().getCodeType().getClass();
            }
            catch (Throwable t) {
                LOG.error("find code " + type, t);
            }
        }
        return declaringCodeTypeClass;
    }

    private <T> T findCode(final Class<T> type, ICodeType codeType) {
        final Holder codeHolder = new Holder(ICode.class);
        ICodeVisitor v = new ICodeVisitor(){

            public boolean visit(ICode code, int treeLevel) {
                if (code.getClass() == type) {
                    codeHolder.setValue((Object)code);
                    return false;
                }
                return true;
            }
        };
        codeType.visit(v);
        return (T)codeHolder.getValue();
    }

    public <CODE_ID_TYPE, CODE extends ICode<CODE_ID_TYPE>> CODE getCode(Class<CODE> type) {
        Class declaringCodeTypeClass = this.getDeclaringCodeTypeClass(type);
        ICodeType codeType = this.getCodeType(declaringCodeTypeClass);
        return (CODE)((ICode)this.findCode(type, codeType));
    }

    public <CODE_ID_TYPE, CODE extends ICode<CODE_ID_TYPE>> CODE getCode(Long partitionId, Class<CODE> type) {
        Class declaringCodeTypeClass = this.getDeclaringCodeTypeClass(type);
        ICodeType codeType = this.getCodeType(partitionId, declaringCodeTypeClass);
        return (CODE)((ICode)this.findCode(type, codeType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType<?, ?>> T reloadCodeType(Class<T> type) throws ProcessingException {
        this.unloadCodeType(type);
        ICodeType instance = this.getRemoteService().getCodeType(type);
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            if (instance != null) {
                state.m_cache.put(type, instance);
            }
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICodeType<?, ?>> reloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) throws ProcessingException {
        for (Class<ICodeType<?, ?>> clazz : types) {
            this.unloadCodeType(clazz);
        }
        List list = this.getRemoteService().getCodeTypes(types);
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            int i = 0;
            for (Class<ICodeType<?, ?>> clazz : types) {
                ICodeType codeInstance = (ICodeType)CollectionUtility.getElement((List)list, (int)i);
                if (codeInstance != null) {
                    state.m_cache.put(clazz, codeInstance);
                }
                ++i;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BundleClassDescriptor> getAllCodeTypeClasses(String classPrefix) {
        if (classPrefix == null) {
            return CollectionUtility.hashSet((Object[])new BundleClassDescriptor[0]);
        }
        ServiceState state = this.getServiceState();
        Object object = state.m_codeTypeClassDescriptorMapLock;
        synchronized (object) {
            Set<BundleClassDescriptor> a = state.m_codeTypeClassDescriptorMap.get(classPrefix);
            if (a != null) {
                return CollectionUtility.hashSet(a);
            }
            HashSet<BundleClassDescriptor> verifiedCodeTypes = new HashSet<BundleClassDescriptor>();
            Set remoteCodeTypes = this.getRemoteService().getAllCodeTypeClasses(classPrefix);
            for (BundleClassDescriptor d : remoteCodeTypes) {
                try {
                    Platform.getBundle((String)d.getBundleSymbolicName()).loadClass(d.getClassName());
                    verifiedCodeTypes.add(d);
                }
                catch (Throwable t) {
                    LOG.error("Missing code-type in client: " + d.getClassName() + ", defined in server-side bundle " + d.getBundleSymbolicName());
                }
            }
            state.m_codeTypeClassDescriptorMap.put(classPrefix, verifiedCodeTypes);
            return verifiedCodeTypes;
        }
    }

    public List<ICodeType<?, ?>> getAllCodeTypes(String classPrefix) {
        ArrayList list = new ArrayList();
        for (BundleClassDescriptor d : this.getAllCodeTypeClasses(classPrefix)) {
            try {
                list.add(Platform.getBundle((String)d.getBundleSymbolicName()).loadClass(d.getClassName()));
            }
            catch (Throwable t) {
                LOG.warn("Loading " + d.getClassName() + " of bundle " + d.getBundleSymbolicName(), t);
            }
        }
        return this.getCodeTypes(list);
    }

    public List<ICodeType<?, ?>> getAllCodeTypes(String classPrefix, Long partitionId) {
        return this.getAllCodeTypes(classPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ICodeType> void unloadCodeType(Class<T> type) {
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            state.m_cache.remove(type);
        }
    }

    protected ICodeService getRemoteService() {
        return (ICodeService)ServiceTunnelUtility.createProxy(ICodeService.class, (IServiceTunnel)ClientSyncJob.getCurrentSession().getServiceTunnel());
    }

    private static class ServiceState {
        final Object m_cacheLock = new Object();
        final Map<Class<? extends ICodeType<?, ?>>, ICodeType<?, ?>> m_cache = new HashMap();
        final Object m_codeTypeClassDescriptorMapLock = new Object();
        final Map<String, Set<BundleClassDescriptor>> m_codeTypeClassDescriptorMap = new HashMap<String, Set<BundleClassDescriptor>>();

        private ServiceState() {
        }
    }
}

