/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.commons.cache.IHttpSessionCacheService;
import org.eclipse.scout.rt.server.commons.servletfilter.FilterConfigInjection;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class ServerJobServletFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerJobServletFilter.class);
    private FilterConfigInjection m_injection;

    public void init(FilterConfig config0) throws ServletException {
        this.m_injection = new FilterConfigInjection(config0, this.getClass());
    }

    public void destroy() {
        this.m_injection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        IServerSession serverSession;
        FilterConfigInjection.FilterConfig config = this.m_injection.getConfig(sreq);
        if (!config.isActive()) {
            chain.doFilter(sreq, sres);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)sreq;
        HttpServletResponse res = (HttpServletResponse)sres;
        if ("/process".equals(req.getServletPath())) {
            chain.doFilter(sreq, sres);
            return;
        }
        HttpSession httpSession = req.getSession();
        synchronized (httpSession) {
            serverSession = (IServerSession)((IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class)).getAndTouch(IServerSession.class.getName(), req, res);
            if (serverSession == null) {
                Class serverSessionClass;
                String qname = config.getInitParameter("session");
                if (qname == null) {
                    throw new ServletException("Expected init-param \"session\"");
                }
                int i = qname.lastIndexOf(46);
                try {
                    serverSessionClass = Platform.getBundle((String)qname.substring(0, i)).loadClass(qname);
                }
                catch (ClassNotFoundException e) {
                    throw new ServletException("Loading class " + qname, (Throwable)e);
                }
                try {
                    serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(serverSessionClass, null);
                    ((IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class)).put(IServerSession.class.getName(), (Object)serverSession, req, res);
                }
                catch (Throwable t) {
                    LOG.error("create session " + serverSessionClass, t);
                    res.sendError(403);
                    return;
                }
            }
        }
        Map<Class, Object> backup = ThreadContext.backup();
        try {
            ThreadContext.putHttpServletRequest(req);
            ThreadContext.putHttpServletResponse(res);
            ServerJob job = this.createServiceTunnelServerJob(serverSession, chain, sreq, sres);
            IStatus status = job.runNow((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                try {
                    ProcessingException p = new ProcessingException(status);
                    p.addContextMessage("Client=" + req.getRemoteUser() + "@" + req.getRemoteAddr() + "/" + req.getRemoteHost());
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(p);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            ThreadContext.restore(backup);
        }
    }

    protected ServerJob createServiceTunnelServerJob(IServerSession serverSession, FilterChain chain, ServletRequest request, ServletResponse response) {
        return new ServiceTunnelServiceJob(serverSession, chain, request, response);
    }

    protected class ServiceTunnelServiceJob
    extends ServerJob {
        protected FilterChain m_chain;
        protected ServletRequest m_request;
        protected ServletResponse m_response;

        public ServiceTunnelServiceJob(IServerSession serverSession, FilterChain chain, ServletRequest request, ServletResponse response) {
            super("ServiceTunnel", serverSession);
            this.m_chain = chain;
            this.m_request = request;
            this.m_response = response;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            this.m_chain.doFilter(this.m_request, this.m_response);
            return Status.OK_STATUS;
        }
    }
}

