/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.lookup;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.ISqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.SQL;
import org.eclipse.scout.rt.server.services.lookup.AbstractLookupService;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractSqlLookupService<T>
extends AbstractLookupService<T> {
    private static final Pattern REFUSING_ALL_TAGS_REGEX = Pattern.compile("<all>\\s*and\\s*([0-9]+)\\s*=\\s*([0-9]+)\\s*</all>", 32);
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSqlLookupService.class);

    @ConfigProperty(value="SQL")
    @Order(value=10.0)
    protected String getConfiguredSqlSelect() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=20.0)
    protected int getConfiguredSortColumn() {
        return 1;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected List<ILookupRow<T>> execLoadLookupRows(String originalSql, String preprocessedSql, ILookupCall<T> call) throws ProcessingException {
        Object[][] data = SQL.selectLimited(preprocessedSql, call.getMaxRowCount(), call);
        if (this.getConfiguredSortColumn() >= 0) {
            AbstractSqlLookupService.sortData(data, this.getConfiguredSortColumn());
        }
        try {
            Class genericsParameterClass = Object.class;
            try {
                genericsParameterClass = TypeCastUtility.getGenericsParameterClass(((Object)((Object)this)).getClass(), ILookupService.class);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to calculate type parameters for lookup service '" + ((Object)((Object)this)).getClass().getName() + "'. No key type validation will be performed.");
            }
            return AbstractSqlLookupService.createLookupRowArray(data, call, genericsParameterClass);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessingException("Unable to load lookup rows for lookup service '" + ((Object)((Object)this)).getClass().getName() + "'.", (Throwable)e);
        }
    }

    public List<ILookupRow<T>> getDataByKey(ILookupCall<T> call) throws ProcessingException {
        String sql = this.getConfiguredSqlSelect();
        return this.execLoadLookupRows(sql, this.filterSqlByKey(sql), call);
    }

    public List<ILookupRow<T>> getDataByText(ILookupCall<T> call) throws ProcessingException {
        if (call.getText() != null) {
            String s = call.getText();
            String sqlWildcard = ((ISqlService)SERVICES.getService(ISqlService.class)).getSqlStyle().getLikeWildcard();
            call.setText(s.replaceAll("[*]", sqlWildcard));
        }
        String sql = this.getConfiguredSqlSelect();
        return this.execLoadLookupRows(sql, this.filterSqlByText(sql), call);
    }

    public List<ILookupRow<T>> getDataByAll(ILookupCall<T> call) throws ProcessingException {
        String sql = this.getConfiguredSqlSelect();
        if (AbstractSqlLookupService.containsRefusingAllTag(sql)) {
            throw new VetoException(ScoutTexts.get((String)"SearchTextIsTooGeneral", (String[])new String[0]));
        }
        List<ILookupRow<T>> rows = this.execLoadLookupRows(sql, this.filterSqlByAll(sql), call);
        return rows;
    }

    public List<ILookupRow<T>> getDataByRec(ILookupCall<T> call) throws ProcessingException {
        String sql = this.getConfiguredSqlSelect();
        return this.execLoadLookupRows(sql, this.filterSqlByRec(sql), call);
    }

    protected String filterSqlByKey(String sqlSelect) {
        return StringUtility.removeTagBounds((String)StringUtility.removeTags((String)sqlSelect, (String[])new String[]{"text", "all", "rec"}), (String)"key");
    }

    protected String filterSqlByText(String sqlSelect) {
        return StringUtility.removeTagBounds((String)StringUtility.removeTags((String)sqlSelect, (String[])new String[]{"key", "all", "rec"}), (String)"text");
    }

    protected String filterSqlByAll(String sqlSelect) {
        return StringUtility.removeTagBounds((String)StringUtility.removeTags((String)sqlSelect, (String[])new String[]{"key", "text", "rec"}), (String)"all");
    }

    protected static boolean containsRefusingAllTag(String sqlSelect) {
        Matcher m = REFUSING_ALL_TAGS_REGEX.matcher(sqlSelect.toLowerCase());
        return m.find() && !m.group(1).equals(m.group(2));
    }

    protected String filterSqlByRec(String sqlSelect) {
        return StringUtility.removeTagBounds((String)StringUtility.removeTags((String)sqlSelect, (String[])new String[]{"key", "text", "all"}), (String)"rec");
    }
}

