/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.ClassIdentifier;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.extension.AbstractExtensionRegistryItem;
import org.eclipse.scout.rt.shared.extension.ExtensionStack;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.IllegalExtensionException;

public class ExtensionRegistryItem
extends AbstractExtensionRegistryItem {
    private final ClassIdentifier m_ownerClass;
    private final Class<?> m_declaringClass;
    private final Class<?> m_extensionClass;

    public ExtensionRegistryItem(ClassIdentifier originalClass, Class<?> extensionClass, Double modelOrder, long order) {
        this(originalClass, null, extensionClass, modelOrder, order);
    }

    public ExtensionRegistryItem(ClassIdentifier originalClass, Class<?> declaringClass, Class<?> extensionClass, Double modelOrder, long order) {
        super(order, modelOrder);
        this.m_ownerClass = originalClass;
        this.m_declaringClass = declaringClass;
        this.m_extensionClass = extensionClass;
    }

    public <T> T createInstance(Object owner, ExtensionStack extensionStack) {
        Object declaringObject = null;
        if (this.getDeclaringClass() != null) {
            if (extensionStack == null) {
                throw new IllegalStateException("extension stack is null");
            }
            declaringObject = extensionStack.findContextObjectByClass(this.getDeclaringClass());
        }
        return this.createInstance(owner, declaringObject);
    }

    public <T> T createInstance(Object owner, Object declaringObject) {
        Object resultingInstance = null;
        ProcessingException ex = null;
        try {
            boolean isExtension = IExtension.class.isAssignableFrom(this.m_extensionClass);
            resultingInstance = isExtension ? (this.getDeclaringClass() == null ? BeanUtility.createInstance(this.m_extensionClass, (Object[])new Object[]{owner}) : BeanUtility.createInstance(this.m_extensionClass, (Object[])new Object[]{declaringObject, owner})) : (this.getDeclaringClass() == null ? BeanUtility.createInstance(this.m_extensionClass, (Object[])new Object[0]) : BeanUtility.createInstance(this.m_extensionClass, (Object[])new Object[]{declaringObject}));
        }
        catch (ProcessingException e) {
            ex = e;
        }
        if (resultingInstance == null) {
            throw new IllegalExtensionException("Cannot create instance of class '" + this.m_extensionClass.getName() + "'. No constructor found that matches available input parameters.", ex);
        }
        Double order = this.getNewModelOrder();
        if (order != null && resultingInstance instanceof IOrdered) {
            ((IOrdered)resultingInstance).setOrder(order.doubleValue());
        }
        return (T)resultingInstance;
    }

    public Class<?> getOriginalClass() {
        return this.m_ownerClass.getLastSegment();
    }

    public ClassIdentifier getOriginalClassIdentifier() {
        return this.m_ownerClass;
    }

    public Class<?> getDeclaringClass() {
        return this.m_declaringClass;
    }

    public Class<?> getExtensionClass() {
        return this.m_extensionClass;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_declaringClass == null ? 0 : this.m_declaringClass.hashCode());
        result = 31 * result + (this.m_extensionClass == null ? 0 : this.m_extensionClass.hashCode());
        result = 31 * result + (this.m_ownerClass == null ? 0 : this.m_ownerClass.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ExtensionRegistryItem)) {
            return false;
        }
        ExtensionRegistryItem other = (ExtensionRegistryItem)obj;
        if (this.m_declaringClass == null ? other.m_declaringClass != null : !this.m_declaringClass.equals(other.m_declaringClass)) {
            return false;
        }
        if (this.m_extensionClass == null ? other.m_extensionClass != null : !this.m_extensionClass.equals(other.m_extensionClass)) {
            return false;
        }
        return !(this.m_ownerClass == null ? other.m_ownerClass != null : !this.m_ownerClass.equals((Object)other.m_ownerClass));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Extension '").append(this.m_extensionClass.getName()).append("' for '").append(this.m_ownerClass).append("'.");
        return sb.toString();
    }
}

