/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelResponse;

public class ServiceTunnelResponse
implements IServiceTunnelResponse {
    private static final long serialVersionUID = 0L;
    private transient int m_httpCode;
    private transient String m_soapOperation;
    private Object m_data;
    private Object[] m_outVars;
    private Throwable m_exception;
    private Set<IClientNotification> m_clientNotifications;
    private Long m_processingDuration;

    public ServiceTunnelResponse() {
    }

    public ServiceTunnelResponse(Object data, Object[] outVars, Throwable t) {
        this(0, data, outVars, t);
    }

    public ServiceTunnelResponse(int httpCode, Object data, Object[] outVars, Throwable t) {
        this.m_httpCode = httpCode;
        this.m_data = data;
        if (outVars != null) {
            this.m_outVars = outVars;
        }
        this.m_exception = t;
    }

    @Override
    public String getSoapOperation() {
        return this.m_soapOperation;
    }

    public void setSoapOperation(String soapOperation) {
        this.m_soapOperation = soapOperation;
    }

    @Override
    public int getHttpCode() {
        return this.m_httpCode;
    }

    @Override
    public Object getData() {
        return this.m_data;
    }

    @Override
    public Object[] getOutVars() {
        return this.m_outVars;
    }

    @Override
    public Throwable getException() {
        return this.m_exception;
    }

    @Override
    public Set<IClientNotification> getClientNotifications() {
        return CollectionUtility.hashSet(this.m_clientNotifications);
    }

    public void setClientNotifications(Collection<? extends IClientNotification> clientNotifications) {
        this.m_clientNotifications = CollectionUtility.hashSet(clientNotifications);
    }

    @Override
    public Long getProcessingDuration() {
        return this.m_processingDuration;
    }

    public void setProcessingDuration(Long millis) {
        this.m_processingDuration = millis;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Response[data=" + this.m_data + ", vars=" + (this.m_outVars == null ? "" : Arrays.asList(this.m_outVars)) + ", exception=" + this.m_exception + "]");
        return buf.toString();
    }
}

