/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form;

import java.util.WeakHashMap;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldProposalForm;
import org.eclipse.scout.rt.ui.rap.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.form.IRwtScoutForm;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.rap.util.FocusUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class RwtScoutForm
extends RwtScoutComposite<IForm>
implements IRwtScoutForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutForm.class);
    private static final String VARIANT_FORM = "form";
    private FormListener m_scoutFormListener;
    private WeakHashMap<FormEvent, Object> m_consumedScoutFormEvents = new WeakHashMap();

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        container.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_FORM);
        IRwtScoutFormField group = this.getUiEnvironment().createFormField(container, (IFormField)((IForm)this.getScoutObject()).getRootGroupBox());
        Composite field = group.getUiContainer();
        this.setUiContainer(container);
        this.setUiField((Control)field);
        RwtScoutFormFieldGridData layoutData = new RwtScoutFormFieldGridData((IFormField)((IForm)this.getScoutObject()).getRootGroupBox());
        this.getUiField().setLayoutData((Object)layoutData);
        container.setLayout((Layout)new LogicalGridLayout(0, 0));
        if (((IForm)this.getScoutObject()).getOuterForm() == null) {
            container.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot(parent));
        }
    }

    @Override
    protected void attachScout() {
        IEventHistory h;
        super.attachScout();
        if (this.getScoutObject() instanceof IContentAssistFieldProposalForm) {
            this.getUiContainer().setData("org.eclipse.rap.rwt.customVariant", (Object)"proposal-form");
        }
        if (this.m_scoutFormListener == null) {
            this.m_scoutFormListener = new P_ScoutFormListener();
            ((IForm)this.getScoutObject()).addFormListener(this.m_scoutFormListener);
        }
        if ((h = ((IForm)this.getScoutObject()).getEventHistory()) != null) {
            for (FormEvent e : h.getRecentEvents()) {
                switch (e.getType()) {
                    case 4000: 
                    case 6000: 
                    case 6010: {
                        this.handleScoutFormEventInUi(e);
                    }
                }
            }
        }
        this.setInitialFocus();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutFormListener != null) {
            ((IForm)this.getScoutObject()).removeFormListener(this.m_scoutFormListener);
            this.m_scoutFormListener = null;
        }
    }

    @Override
    public Composite getUiFormPane() {
        return this.getUiField();
    }

    public Composite getUiField() {
        return (Composite)super.getUiField();
    }

    @Override
    public void setInitialFocus() {
        IFormField modelField = null;
        IEventHistory h = ((IForm)this.getScoutObject()).getEventHistory();
        if (h != null) {
            for (FormEvent e : h.getRecentEvents()) {
                if (e.getType() != 6020) continue;
                modelField = e.getFormField();
                break;
            }
        }
        if (modelField == null) {
            this.setFocusOnFirstField();
        } else {
            this.handleRequestFocusFromScout(modelField, true);
        }
    }

    private void setFocusOnFirstField() {
        Control firstFocusableControl = FocusUtility.findFirstFocusableControl(this.getUiField());
        if (firstFocusableControl != null) {
            firstFocusableControl.setFocus();
        }
    }

    private Composite findUiContainer(IFormField modelField) {
        if (modelField == null) {
            return null;
        }
        for (Control comp : RwtUtility.findChildComponents((Widget)this.getUiContainer(), Control.class)) {
            IRwtScoutComposite composite = RwtScoutFieldComposite.getCompositeOnWidget((Widget)comp);
            if (composite == null || composite.getScoutObject() != modelField) continue;
            return composite.getUiContainer();
        }
        return null;
    }

    protected void handleScoutFormEventInUi(FormEvent e) {
        if (this.m_consumedScoutFormEvents.containsKey(e)) {
            return;
        }
        this.m_consumedScoutFormEvents.put(e, Boolean.TRUE);
        switch (e.getType()) {
            case 4000: {
                this.handlePrintFromScout(e);
                break;
            }
            case 6000: {
                Shell sh = this.getUiFormPane().getShell();
                sh.isVisible();
                break;
            }
            case 6010: {
                Shell sh = this.getUiFormPane().getShell();
                sh.isVisible();
                break;
            }
            case 6020: {
                this.handleRequestFocusFromScout(e.getFormField(), false);
            }
        }
    }

    protected void handlePrintFromScout(FormEvent e) {
        LOG.error("Printing in RAP not supported");
    }

    protected void handleRequestFocusFromScout(IFormField modelField, boolean force) {
        if (modelField == null) {
            return;
        }
        Composite comp = this.findUiContainer(modelField);
        Control control = FocusUtility.findFirstFocusableControl(comp);
        if (control != null) {
            if (force) {
                control.forceFocus();
            } else {
                control.setFocus();
            }
        }
    }

    private class P_ScoutFormListener
    implements FormListener {
        private P_ScoutFormListener() {
        }

        public void formChanged(final FormEvent e) {
            Display display = RwtScoutForm.this.getUiEnvironment().getDisplay();
            if (display == null) {
                return;
            }
            switch (e.getType()) {
                case 5000: {
                    break;
                }
                case 4000: 
                case 6000: 
                case 6010: 
                case 6020: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            if (RwtScoutForm.this.getUiFormPane() != null && !RwtScoutForm.this.getUiFormPane().isDisposed()) {
                                RwtScoutForm.this.handleScoutFormEventInUi(e);
                            }
                        }
                    };
                    RwtScoutForm.this.getUiEnvironment().invokeUiLater(t);
                }
            }
        }
    }
}

