/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.groupbox.layout;

import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.groupbox.layout.ButtonBarLayoutData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ButtonBarLayout
extends Layout {
    private static final long serialVersionUID = 1L;
    private final int m_style;
    public int verticalGap;
    public int horizontalGap;

    public ButtonBarLayout(int style) {
        this.m_style = style;
        this.verticalGap = 4;
        this.horizontalGap = 4;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = new Point(0, 0);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c.getVisible()) {
                Point cSize = c.computeSize(-1, -1, flushCache);
                cSize.x += 15;
                cSize.x = Math.max(cSize.x, UiDecorationExtensionPoint.getLookAndFeel().getProcessButtonMinWidth());
                cSize.y = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getProcessButtonHeight(), cSize.y);
                cSize = this.addInsets(c, cSize);
                size.x += cSize.x + this.horizontalGap;
                size.y = Math.max(cSize.y, size.y);
            }
            ++n2;
        }
        if (size.x <= 0) {
            size.x = 1;
        }
        if (size.y <= 0) {
            size.y = 1;
        }
        return size;
    }

    private Point addInsets(Control c, Point size) {
        Object data = c.getLayoutData();
        if (data instanceof ButtonBarLayoutData) {
            ButtonBarLayoutData ld = (ButtonBarLayoutData)data;
            size.x += ld.insetLeft + ld.insetRight;
            size.y += ld.insetTop + ld.insetBottom;
        }
        return size;
    }

    private ButtonBarLayoutData getLayoutData(Control c) {
        Object data = c.getLayoutData();
        if (!(data instanceof ButtonBarLayoutData)) {
            data = new ButtonBarLayoutData();
        }
        return (ButtonBarLayoutData)data;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if ((this.m_style & 0x20000) != 0) {
            this.layoutRight(composite);
        } else {
            this.layoutLeft(composite);
        }
    }

    protected void layoutRight(Composite composite) {
        Control[] children = composite.getChildren();
        Rectangle clientArea = composite.getClientArea();
        int fillCount = 0;
        int excessWidth = clientArea.width;
        int i = 0;
        while (i < children.length) {
            if (children[i].getVisible()) {
                ButtonBarLayoutData layoutData = this.getLayoutData(children[i]);
                if (layoutData.fillHorizontal) {
                    ++fillCount;
                }
                Point prefSize = children[i].computeSize(-1, -1, false);
                prefSize.x += 15;
                int width = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getProcessButtonMinWidth(), prefSize.x);
                if (i > 0) {
                    excessWidth -= this.horizontalGap;
                }
                excessWidth -= width + layoutData.insetLeft + layoutData.insetRight;
            }
            ++i;
        }
        int x = clientArea.x + clientArea.width;
        int y = clientArea.y;
        int i2 = children.length - 1;
        while (i2 >= 0) {
            if (children[i2].getVisible()) {
                ButtonBarLayoutData layoutData = this.getLayoutData(children[i2]);
                Point prefSize = children[i2].computeSize(-1, -1, false);
                prefSize.x += 15;
                int width = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getProcessButtonMinWidth(), prefSize.x);
                int height = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getProcessButtonHeight(), prefSize.y);
                if (layoutData.fillHorizontal && fillCount > 0 && excessWidth > 0) {
                    int delta = excessWidth / fillCount;
                    width += delta;
                    excessWidth -= delta;
                    --fillCount;
                }
                Rectangle bounds = new Rectangle(x - (width + layoutData.insetRight), y + layoutData.insetTop, width, height);
                children[i2].setBounds(bounds);
                x -= width + this.horizontalGap + layoutData.insetLeft + layoutData.insetRight;
            }
            --i2;
        }
    }

    protected void layoutLeft(Composite composite) {
        Control[] children = composite.getChildren();
        Rectangle clientArea = composite.getClientArea();
        int fillCount = 0;
        int excessWidth = clientArea.width;
        int i = 0;
        while (i < children.length) {
            if (children[i].getVisible()) {
                ButtonBarLayoutData layoutData = this.getLayoutData(children[i]);
                if (layoutData.fillHorizontal) {
                    ++fillCount;
                }
                Point prefSize = children[i].computeSize(-1, -1, false);
                prefSize.x += 15;
                int width = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getProcessButtonMinWidth(), prefSize.x);
                if (i > 0) {
                    excessWidth -= this.horizontalGap;
                }
                excessWidth -= width + layoutData.insetLeft + layoutData.insetRight;
            }
            ++i;
        }
        int x = clientArea.x;
        int y = clientArea.y;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (element.getVisible()) {
                ButtonBarLayoutData layoutData = this.getLayoutData(element);
                Point prefSize = element.computeSize(-1, -1, false);
                prefSize.x += 15;
                int width = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getProcessButtonMinWidth(), prefSize.x);
                int height = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getProcessButtonHeight(), prefSize.y);
                if (layoutData.fillHorizontal && fillCount > 0 && excessWidth > 0) {
                    int delta = excessWidth / fillCount;
                    width += delta;
                    excessWidth -= delta;
                    --fillCount;
                }
                element.setBounds(x + layoutData.insetLeft, y + layoutData.insetTop, width, height);
                x += width + this.horizontalGap + layoutData.insetLeft + layoutData.insetRight;
            }
            ++n2;
        }
    }
}

