/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.imagebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.eclipse.rap.rwt.client.ClientFile;
import org.eclipse.rap.rwt.dnd.ClientFileTransfer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.ImageTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtScoutContextMenu;
import org.eclipse.scout.rt.ui.rap.ext.ImageViewer;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.AbstractRwtScoutDndSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.imagebox.IRwtScoutImageBox;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RwtScoutImageField
extends RwtScoutFieldComposite<IImageField>
implements IRwtScoutImageBox {
    private static final String CLIENT_FILE_TYPE_IMAGE = "image";
    private Image m_image;
    private RwtContextMenuMarkerComposite m_menuMarkerComposite;
    private RwtScoutContextMenu m_uiContextMenu;
    private P_ContextMenuPropertyListener m_contextMenuPropertyListener;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_menuMarkerComposite = new RwtContextMenuMarkerComposite(container, this.getUiEnvironment(), 0);
        this.getUiEnvironment().getFormToolkit().adapt(this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                if (RwtScoutImageField.this.getUiContextMenu() != null) {
                    Menu uiMenu = RwtScoutImageField.this.getUiContextMenu().getUiMenu();
                    if (e.widget instanceof Control) {
                        Point loc = ((Control)e.widget).toDisplay(e.x, e.y);
                        uiMenu.setLocation(RwtMenuUtility.getMenuLocation(((IImageField)RwtScoutImageField.this.getScoutObject()).getContextMenu().getChildActions(), uiMenu, loc, RwtScoutImageField.this.getUiEnvironment()));
                    }
                    uiMenu.setVisible(true);
                }
            }
        });
        ImageViewer imgViewer = this.getUiEnvironment().getFormToolkit().createImageViewer(this.m_menuMarkerComposite);
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)imgViewer);
        imgViewer.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                RwtScoutImageField.this.freeResources();
            }
        });
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
    }

    private void freeResources() {
        if (this.m_image != null && !this.m_image.isDisposed() && this.m_image.getDevice() != null) {
            if (this.getUiField() != null && !this.getUiField().isDisposed()) {
                this.getUiField().setImage(null);
            }
            this.m_image.dispose();
            this.m_image = null;
        }
    }

    public ImageViewer getUiField() {
        return (ImageViewer)super.getUiField();
    }

    public RwtScoutContextMenu getUiContextMenu() {
        return this.m_uiContextMenu;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.getUiField().setAlignmentX(RwtUtility.getHorizontalAlignment(((IImageField)this.getScoutObject()).getGridData().horizontalAlignment));
        this.getUiField().setAlignmentY(RwtUtility.getVerticalAlignment(((IImageField)this.getScoutObject()).getGridData().verticalAlignment));
        this.updateAutoFitFromScout();
        this.updateImageFromScout();
        this.attachDndSupport();
        this.updateContextMenuVisibilityFromScout();
        if (((IImageField)this.getScoutObject()).getContextMenu() != null && this.m_contextMenuPropertyListener == null) {
            this.m_contextMenuPropertyListener = new P_ContextMenuPropertyListener();
            ((IImageField)this.getScoutObject()).getContextMenu().addPropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
        }
    }

    protected void attachDndSupport() {
        if (UiDecorationExtensionPoint.getLookAndFeel().isDndSupportEnabled()) {
            new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getUiField());
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_contextMenuPropertyListener != null) {
            ((IImageField)this.getScoutObject()).getContextMenu().removePropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
            this.m_contextMenuPropertyListener = null;
        }
        super.detachScout();
    }

    protected void updateImageFromScout() {
        this.freeResources();
        if (((IImageField)this.getScoutObject()).getImage() instanceof byte[]) {
            this.m_image = new Image((Device)this.getUiField().getDisplay(), (InputStream)new ByteArrayInputStream((byte[])((IImageField)this.getScoutObject()).getImage()));
            this.getUiField().setImage(this.m_image);
        } else if (((IImageField)this.getScoutObject()).getImage() instanceof ImageData) {
            this.m_image = new Image((Device)this.getUiField().getDisplay(), (ImageData)((IImageField)this.getScoutObject()).getImage());
            this.getUiField().setImage(this.m_image);
        } else if (!StringUtility.isNullOrEmpty((CharSequence)((IImageField)this.getScoutObject()).getImageId())) {
            this.getUiField().setImage(this.getUiEnvironment().getIcon(((IImageField)this.getScoutObject()).getImageId()));
        }
        this.getUiField().redraw();
    }

    protected void updateAutoFitFromScout() {
        this.getUiField().setAutoFit(((IImageField)this.getScoutObject()).isAutoFit());
    }

    @Override
    protected void setFocusableFromScout(boolean b) {
        ImageViewer imageViewer = this.getUiField();
        if (imageViewer != null) {
            imageViewer.setFocusable(b);
        }
    }

    protected void updateContextMenuVisibilityFromScout() {
        this.m_menuMarkerComposite.setMarkerVisible(((IImageField)this.getScoutObject()).getContextMenu().isVisible());
        if (((IImageField)this.getScoutObject()).getContextMenu().isVisible()) {
            if (this.m_uiContextMenu == null) {
                this.m_uiContextMenu = new RwtScoutContextMenu(this.getUiField().getShell(), ((IImageField)this.getScoutObject()).getContextMenu(), this.getUiEnvironment());
                this.getUiField().setMenu(this.m_uiContextMenu.getUiMenu());
            }
        } else {
            this.getUiField().setMenu(null);
            if (this.m_uiContextMenu != null) {
                this.m_uiContextMenu.dispose();
            }
            this.m_uiContextMenu = null;
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (CLIENT_FILE_TYPE_IMAGE.equals(name)) {
            this.updateImageFromScout();
        } else if ("autoFit".equals(name)) {
            this.updateAutoFitFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    private class P_ContextMenuPropertyListener
    implements PropertyChangeListener {
        private P_ContextMenuPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                RwtScoutImageField.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutImageField.this.updateContextMenuVisibilityFromScout();
                    }
                });
            }
        }
    }

    private class P_DndSupport
    extends AbstractRwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control) {
            super(scoutObject, scoutDndSupportable, control, RwtScoutImageField.this.getUiEnvironment());
        }

        @Override
        protected TransferObject createScoutTransferableObjectFromFileUpload(DropTargetEvent event, List<File> uploadedFiles) {
            if (ClientFileTransfer.getInstance().isSupportedType(event.currentDataType) && (((IImageField)RwtScoutImageField.this.getScoutObject()).getDropType() & 8) != 0) {
                ClientFile[] clientFiles = (ClientFile[])event.data;
                int index = 0;
                ClientFile[] clientFileArray = clientFiles;
                int n = clientFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientFile clientFile = clientFileArray[n2];
                    String clientFileType = clientFile.getType();
                    if (clientFileType != null && StringUtility.lowercase((String)clientFileType).startsWith(RwtScoutImageField.CLIENT_FILE_TYPE_IMAGE)) {
                        ImageData imageData = new ImageData(uploadedFiles.get(index).getAbsolutePath());
                        return new ImageTransferObject((Object)imageData);
                    }
                    ++index;
                    ++n2;
                }
            }
            return super.createScoutTransferableObjectFromFileUpload(event, uploadedFiles);
        }

        @Override
        protected TransferObject handleUiDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IImageField)RwtScoutImageField.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            JobEx job = this.getUiEnvironment().invokeScoutLater(t, 2345L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleUiDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((IImageField)RwtScoutImageField.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferObject);
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 200L);
        }
    }
}

