/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.snapbox.button;

import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.rap.ext.SnapButtonMaximized;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.snapbox.button.IRwtScoutSnapBoxMaximizedButton;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RwtScoutSnapBoxMaximizedButton
extends RwtScoutFieldComposite<IButton>
implements IRwtScoutSnapBoxMaximizedButton {
    private OptimisticLock m_selectionLock = new OptimisticLock();

    @Override
    protected void initializeUi(Composite parent) {
        SnapButtonMaximized button = this.getUiEnvironment().getFormToolkit().createSnapButtonMaximized(parent);
        this.setUiField((Control)button);
        button.addSelectionListener((SelectionListener)new P_SelectionListener());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setIconIdFromScout(((IButton)this.getScoutObject()).getIconId());
        this.setSelectionFromScout(((IButton)this.getScoutObject()).isSelected());
    }

    public SnapButtonMaximized getUiField() {
        return (SnapButtonMaximized)super.getUiField();
    }

    protected void setSelectionFromScout(boolean booleanValue) {
        this.getUiField().setSelected(booleanValue);
    }

    private void setIconIdFromScout(String iconId) {
        this.getUiField().setImage(this.getUiEnvironment().getIcon(iconId));
    }

    @Override
    protected void setLabelFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getUiField().setText(s);
    }

    @Override
    protected void setFontFromScout(FontSpec scoutFont) {
        this.getUiField().setFont(this.getUiEnvironment().getFont(scoutFont, this.getUiField().getFont()));
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        this.getUiField().setEnabled(b);
    }

    @Override
    protected void setVisibleFromScout(boolean b) {
        if (this.getUiField().getVisible() != b) {
            this.getUiField().setVisible(b);
            RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
        }
    }

    @Override
    protected void setTooltipTextFromScout(String s) {
        this.getUiField().setToolTipText(s);
    }

    protected void handleSelectionFromUi() {
        final boolean selection = !this.getUiField().isSelected();
        Runnable job = new Runnable(){

            @Override
            public void run() {
                ((IButton)RwtScoutSnapBoxMaximizedButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(selection);
            }
        };
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("selected".equals(name)) {
            this.setSelectionFromScout((Boolean)newValue);
        } else if ("iconId".equals(name)) {
            this.setIconIdFromScout((String)newValue);
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    private class P_SelectionListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_SelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RwtScoutSnapBoxMaximizedButton.this.handleSelectionFromUi();
        }
    }
}

