/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.EventListener;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.eventlistprofiler.EventListenerProfiler;
import org.eclipse.scout.commons.eventlistprofiler.IEventListenerSnapshot;
import org.eclipse.scout.commons.eventlistprofiler.IEventListenerSource;

public class EventListenerList
implements IEventListenerSource {
    private static final Object[] NULL_ARRAY = new Object[0];
    private Object listenerListLock = new Object();
    private transient Object[] listenerList = NULL_ARRAY;

    public EventListenerList() {
        if (EventListenerProfiler.getInstance().isEnabled()) {
            EventListenerProfiler.getInstance().registerSourceAsWeakReference(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpListenerList(IEventListenerSnapshot snapshot) {
        Object object = this.listenerListLock;
        synchronized (object) {
            int i = this.listenerList.length - 2;
            while (i >= 0) {
                Class c = (Class)this.listenerList[i];
                Object o = this.listenerList[i + 1];
                if (o instanceof WeakReference) {
                    snapshot.add(c, null, ((WeakReference)o).get());
                } else {
                    snapshot.add(c, null, o);
                }
                i -= 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> T[] getListeners(Class<T> t) {
        Object object = this.listenerListLock;
        synchronized (object) {
            this.maintainListNoLocking();
            Object[] lList = this.listenerList;
            int n = this.getListenerCountNoLock(t);
            EventListener[] result = (EventListener[])Array.newInstance(t, n);
            int j = 0;
            int nullCount = 0;
            int i = lList.length - 2;
            while (i >= 0) {
                if (lList[i] == t) {
                    Object ref = lList[i + 1];
                    if (ref instanceof WeakReference) {
                        result[j] = (EventListener)((WeakReference)ref).get();
                        if (result[j] == null) {
                            ++nullCount;
                        }
                        ++j;
                    } else {
                        result[j++] = (EventListener)ref;
                    }
                }
                i -= 2;
            }
            if (nullCount > 0) {
                EventListener[] tmp = new EventListener[result.length - nullCount];
                j = 0;
                int i2 = 0;
                while (i2 < result.length) {
                    if (result[i2] != null) {
                        tmp[j++] = result[i2];
                    }
                    ++i2;
                }
                result = tmp;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> int getListenerCount(Class<T> t) {
        Object object = this.listenerListLock;
        synchronized (object) {
            return this.getListenerCountNoLock(t);
        }
    }

    private <T extends EventListener> int getListenerCountNoLock(Class<T> t) {
        int count = 0;
        Object[] lList = this.listenerList;
        int i = 0;
        while (i < lList.length) {
            if (t == (Class)lList[i]) {
                ++count;
            }
            i += 2;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void insertAtFront(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        Object ref = listener instanceof WeakEventListener ? new WeakReference<T>(listener) : listener;
        Object object = this.listenerListLock;
        synchronized (object) {
            if (this.listenerList == NULL_ARRAY) {
                this.listenerList = new Object[]{t, ref};
            } else {
                int n = this.listenerList.length + 2;
                int k = 0;
                Object[] tmp = new Object[n];
                if (k < n - 2) {
                    System.arraycopy(this.listenerList, k, tmp, k + 2, n - 2 - k);
                }
                tmp[k] = t;
                tmp[k + 1] = ref;
                this.listenerList = tmp;
            }
            this.maintainListNoLocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void add(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        Object ref = listener instanceof WeakEventListener ? new WeakReference<T>(listener) : listener;
        Object object = this.listenerListLock;
        synchronized (object) {
            if (this.listenerList == NULL_ARRAY) {
                this.listenerList = new Object[]{t, ref};
            } else {
                int i = this.listenerList.length;
                Object[] tmp = new Object[i + 2];
                System.arraycopy(this.listenerList, 0, tmp, 0, i);
                tmp[i] = t;
                tmp[i + 1] = ref;
                this.listenerList = tmp;
            }
            this.maintainListNoLocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void remove(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        Object object = this.listenerListLock;
        synchronized (object) {
            int index = -1;
            int i = this.listenerList.length - 2;
            while (i >= 0) {
                if (this.listenerList[i] == t) {
                    if (this.listenerList[i + 1] instanceof WeakReference) {
                        if (((WeakReference)this.listenerList[i + 1]).get() == listener) {
                            index = i;
                            break;
                        }
                    } else if (this.listenerList[i + 1] == listener) {
                        index = i;
                        break;
                    }
                }
                i -= 2;
            }
            if (index != -1) {
                Object[] tmp = new Object[this.listenerList.length - 2];
                System.arraycopy(this.listenerList, 0, tmp, 0, index);
                if (index < tmp.length) {
                    System.arraycopy(this.listenerList, index + 2, tmp, index, tmp.length - index);
                }
                this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
            }
            this.maintainListNoLocking();
        }
    }

    private void maintainListNoLocking() {
        int j = 0;
        int nullCount = 0;
        int i = this.listenerList.length - 2;
        while (i >= 0) {
            Object ref = this.listenerList[i + 1];
            if (ref instanceof WeakReference) {
                if (((WeakReference)ref).get() == null) {
                    this.listenerList[i + 1] = null;
                    ++nullCount;
                }
            } else if (ref == null) {
                this.listenerList[i + 1] = null;
                ++nullCount;
            }
            i -= 2;
        }
        if (nullCount > 0) {
            Object[] tmp = new Object[this.listenerList.length - nullCount * 2];
            j = 0;
            int i2 = 0;
            while (i2 < this.listenerList.length) {
                if (this.listenerList[i2 + 1] != null) {
                    tmp[j] = this.listenerList[i2];
                    tmp[j + 1] = this.listenerList[i2 + 1];
                    j += 2;
                }
                i2 += 2;
            }
            this.listenerList = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.listenerListLock;
        synchronized (object) {
            Object[] lList = this.listenerList;
            String s = "EventListenerList: ";
            s = String.valueOf(s) + lList.length / 2 + " listeners: ";
            int i = 0;
            while (i <= lList.length - 2) {
                s = String.valueOf(s) + " type " + ((Class)lList[i]).getName();
                s = String.valueOf(s) + " listener " + lList[i + 1];
                i += 2;
            }
            return s;
        }
    }
}

