/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

public enum TriState {
    FALSE(Boolean.FALSE),
    TRUE(Boolean.TRUE),
    UNDEFINED(null);

    private final Boolean m_value;

    private TriState(Boolean value) {
        this.m_value = value;
    }

    public Boolean getBooleanValue() {
        return this.m_value;
    }

    public Integer getIntegerValue() {
        return this.m_value != null ? Integer.valueOf(this.m_value != false ? 1 : 0) : null;
    }

    public boolean isTrue() {
        return this.m_value != null && this.m_value != false;
    }

    public boolean isFalse() {
        return this.m_value != null && this.m_value == false;
    }

    public boolean isUndefined() {
        return this.m_value == null;
    }

    public static TriState parse(Object value) {
        if (value == null) {
            return UNDEFINED;
        }
        if (value instanceof TriState) {
            return (TriState)((Object)value);
        }
        if (value instanceof Boolean) {
            return TriState.parseBoolean((Boolean)value);
        }
        if (value instanceof Number) {
            return TriState.parseInt(((Number)value).intValue());
        }
        if (value instanceof String) {
            return TriState.parseString((String)value);
        }
        throw new IllegalArgumentException("value of unknown type " + value + " [" + value.getClass() + "]");
    }

    private static TriState parseBoolean(Boolean value) {
        if (value.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    private static TriState parseInt(int i) {
        switch (i) {
            case 0: {
                return FALSE;
            }
            case 1: {
                return TRUE;
            }
        }
        return UNDEFINED;
    }

    private static TriState parseString(String value) {
        if ("true".equals(value)) {
            return TRUE;
        }
        if ("false".equals(value)) {
            return FALSE;
        }
        if ("0".equals(value)) {
            return FALSE;
        }
        if ("1".equals(value)) {
            return TRUE;
        }
        return UNDEFINED;
    }

    @Deprecated
    public static TriState parseTriState(Object value) {
        return TriState.parse(value);
    }
}

