/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.serialization;

import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.commons.osgi.BundleListClassLoader;
import org.eclipse.scout.commons.serialization.BundleObjectSerializer;
import org.eclipse.scout.commons.serialization.IObjectReplacer;
import org.eclipse.scout.commons.serialization.IObjectSerializer;
import org.eclipse.scout.commons.serialization.IObjectSerializerFactory;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BundleObjectSerializerFactory
implements IObjectSerializerFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BundleObjectSerializerFactory.class);
    private static final String CONTEXT_FINDER_CLASS_NAME = "org.eclipse.core.runtime.internal.adaptor.ContextFinder";
    private BundleListClassLoader m_bundleBasedClassLoader;

    public BundleObjectSerializerFactory() {
        String[] bundleOrderPrefixes = SerializationUtility.getBundleOrderPrefixes();
        Bundle[] orderedBundleLists = BundleInspector.getOrderedBundleList(bundleOrderPrefixes);
        ClassLoader parent = this.getOsgiParentClassLoader();
        this.m_bundleBasedClassLoader = new BundleListClassLoader(parent, orderedBundleLists);
    }

    @Override
    public IObjectSerializer createObjectSerializer(IObjectReplacer objectReplacer) {
        return new BundleObjectSerializer(objectReplacer, this.m_bundleBasedClassLoader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.m_bundleBasedClassLoader;
    }

    protected ClassLoader getOsgiParentClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && CONTEXT_FINDER_CLASS_NAME.equals(contextClassLoader.getClass().getName())) {
            return contextClassLoader.getParent();
        }
        Object osgiContextClassLoader = null;
        try {
            BundleContext context = Activator.getDefault().getBundle().getBundleContext();
            ServiceReference[] serviceReferenceArray = context.getServiceReferences(ClassLoader.class.getName(), null);
            int n = serviceReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                if ("contextClassLoader".equals(ref.getProperty("equinox.classloader.type"))) {
                    try {
                        osgiContextClassLoader = (ClassLoader)context.getService(ref);
                        break;
                    }
                    finally {
                        context.ungetService(ref);
                    }
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            LOG.error("cannot determine OSGi context class loader", t);
        }
        if (osgiContextClassLoader == null) {
            return null;
        }
        if (CONTEXT_FINDER_CLASS_NAME.equals(osgiContextClassLoader.getClass().getName())) {
            return ((ClassLoader)osgiContextClassLoader).getParent();
        }
        return osgiContextClassLoader;
    }
}

