/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;

public class BlockingCondition {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BlockingCondition.class);
    private boolean m_blocking;
    private final List<ClientJob> m_blockingJobs;

    public BlockingCondition(boolean blocking) {
        this.m_blocking = blocking;
        this.m_blockingJobs = new ArrayList<ClientJob>();
    }

    public boolean isBlocking() {
        return this.m_blocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean blocking) {
        if (this.m_blocking != blocking) {
            if (blocking) {
                BlockingCondition blockingCondition = this;
                synchronized (blockingCondition) {
                    this.m_blocking = true;
                }
            } else {
                this.release();
            }
        }
    }

    public void waitFor() throws InterruptedException {
        IDesktop desktop;
        IDesktop iDesktop = desktop = ClientJob.getCurrentSession() != null ? ClientJob.getCurrentSession().getDesktop() : null;
        if (desktop == null) {
            this.waitForInternal();
        } else {
            P_DesktopListener desktopListener = new P_DesktopListener();
            desktop.addDesktopListener(desktopListener);
            try {
                this.waitForInternal();
            }
            finally {
                desktop.removeDesktopListener(desktopListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void waitForInternal() throws InterruptedException {
        block5: {
            clientJob = null;
            var2_2 = this;
            synchronized (var2_2) {
                if (!this.m_blocking) break block5;
                job = ClientJob.getJobManager().currentJob();
                if (!(job instanceof ClientJob)) ** GOTO lbl13
                clientJob = (ClientJob)job;
                this.m_blockingJobs.add(clientJob);
                break block5;
lbl-1000:
                // 1 sources

                {
                    this.wait();
lbl13:
                    // 2 sources

                    ** while (this.m_blocking)
                }
lbl14:
                // 1 sources

                return;
            }
        }
        if (clientJob != null) {
            clientJob.waitFor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        BlockingCondition blockingCondition = this;
        synchronized (blockingCondition) {
            if (this.m_blocking) {
                this.m_blocking = false;
                this.notifyAll();
                for (ClientJob clientJob : this.m_blockingJobs) {
                    try {
                        clientJob.releaseWaitFor();
                    }
                    catch (RuntimeException e) {
                        LOG.error(String.format("Failed to release lock on client job [job=%s].", clientJob), (Throwable)e);
                    }
                }
                this.m_blockingJobs.clear();
            }
        }
    }

    private class P_DesktopListener
    implements DesktopListener {
        private P_DesktopListener() {
        }

        @Override
        public void desktopChanged(DesktopEvent evt) {
            if (evt.getType() == 100) {
                BlockingCondition.this.release();
            }
        }
    }
}

