/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class ExtensionUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ExtensionUtility.class);

    private ExtensionUtility() {
    }

    public static void removeByType(List<?> objectList, Class<?> ... types) {
        if (objectList == null || types == null || types.length == 0) {
            return;
        }
        Iterator<?> it = objectList.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next == null || !CompareUtility.isOneOf(next.getClass(), (Object[])types)) continue;
            it.remove();
        }
    }

    public static Object getEnclosingObject(Object o) {
        if (o == null) {
            return null;
        }
        int nestedCount = o.getClass().getName().replaceAll("[^$]", "").trim().length();
        if (nestedCount == 0) {
            return null;
        }
        Object enclosingObject = null;
        try {
            Field f = o.getClass().getDeclaredField("this$" + (nestedCount - 1));
            f.setAccessible(true);
            enclosingObject = f.get(o);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return enclosingObject;
    }

    public static Object getEnclosingObject(Object o, Class<?> type) {
        Object enclosingObject = ExtensionUtility.getEnclosingObject(o);
        if (type != null) {
            while (enclosingObject != null && !type.isInstance(enclosingObject)) {
                enclosingObject = ExtensionUtility.getEnclosingObject(enclosingObject);
            }
        }
        return enclosingObject;
    }
}

