/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;
import org.eclipse.scout.rt.shared.extension.IllegalExtensionException;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractContributionComposite
implements IContributionOwner,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, ArrayList<?>> m_contributionsByType;
    private Map<Class<?>, Object> m_contributionsByClass;

    protected AbstractContributionComposite() {
        this(null, true);
    }

    protected AbstractContributionComposite(Object o, boolean useScope) {
        IInternalExtensionRegistry extensionRegistry = (IInternalExtensionRegistry)SERVICES.getService(IInternalExtensionRegistry.class);
        try {
            if (useScope) {
                extensionRegistry.pushScope(this.getClass());
            }
            this.initContributionsMap(o, extensionRegistry);
            this.initConfig();
        }
        finally {
            if (useScope) {
                extensionRegistry.popScope();
            }
        }
    }

    protected void initConfig() {
    }

    private void initContributionsMap(Object o, IInternalExtensionRegistry extensionRegistry) {
        Object owner = this;
        if (o != null) {
            owner = o;
        }
        List contributionsForMe = extensionRegistry.createContributionsFor(owner, null);
        this.m_contributionsByType = new HashMap();
        this.m_contributionsByClass = new HashMap(contributionsForMe.size());
        if (CollectionUtility.hasElements(contributionsForMe)) {
            for (Object contribution : contributionsForMe) {
                this.m_contributionsByClass.put(contribution.getClass(), contribution);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.m_contributionsByClass == null || this.m_contributionsByType == null) {
            IInternalExtensionRegistry extensionRegistry = (IInternalExtensionRegistry)SERVICES.getService(IInternalExtensionRegistry.class);
            this.initContributionsMap(null, extensionRegistry);
        }
    }

    protected Collection<Object> geAllContributionsInternal() {
        return this.m_contributionsByClass.values();
    }

    @Override
    public List<Object> getAllContributions() {
        return CollectionUtility.arrayList(this.geAllContributionsInternal());
    }

    @Override
    public <T> List<T> getContributionsByClass(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Contribution type class must be specified.");
        }
        ArrayList<Object> contributionsOfType = this.m_contributionsByType.get(type);
        if (contributionsOfType == null) {
            Collection<Object> values = this.m_contributionsByClass.values();
            contributionsOfType = new ArrayList(values.size());
            for (Object o : values) {
                if (!type.isAssignableFrom(o.getClass())) continue;
                T contribution = type.cast(o);
                contributionsOfType.add(contribution);
            }
            contributionsOfType.trimToSize();
            this.m_contributionsByType.put(type, contributionsOfType);
        }
        return CollectionUtility.arrayList(contributionsOfType);
    }

    @Override
    public <T> T getContribution(Class<T> contribution) {
        if (contribution == null) {
            throw new IllegalArgumentException("Contribution class must be specified.");
        }
        Object object = this.m_contributionsByClass.get(contribution);
        if (object != null) {
            return contribution.cast(object);
        }
        for (Object o : this.m_contributionsByClass.values()) {
            IContributionOwner comp;
            if (!(o instanceof IContributionOwner) || (object = (comp = (IContributionOwner)o).getContribution(contribution)) == null) continue;
            return contribution.cast(object);
        }
        throw new IllegalExtensionException("No contribution of type '" + contribution.getName() + "' exists for class '" + this.getClass().getName() + "'.");
    }
}

