/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.MenuSizeEstimator;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.mobile.action.IRwtScoutActionButton;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RwtScoutActionButton
extends RwtScoutComposite<IAction>
implements IRwtScoutActionButton {
    private boolean m_handleActionPending;
    private int m_menuOpeningDirection = 1024;
    private boolean m_ellipsisRemovalEnabled = true;

    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        int style = this.createButtonStyle();
        Button uiButton = this.getUiEnvironment().getFormToolkit().createButton(container, "", style);
        uiButton.addSelectionListener((SelectionListener)new P_RwtSelectionListener());
        this.initLayout(container, uiButton);
        this.setUiField((Control)uiButton);
        this.setUiContainer(container);
    }

    protected void initLayout(Composite container, Button uiButton) {
        container.setLayout((Layout)new LogicalGridLayout(0, 0));
        LogicalGridData data = new LogicalGridData();
        data.useUiWidth = true;
        data.useUiHeight = false;
        uiButton.setLayoutData((Object)data);
    }

    protected int createButtonStyle() {
        int style = 0x1000000;
        style = this.hasChildActions() ? (style |= 2) : (style |= 8);
        return style;
    }

    protected void attachScout() {
        super.attachScout();
        IAction action = (IAction)this.getScoutObject();
        this.setIconIdFromScout(action.getIconId());
        this.setTextFromScout(action.getText());
        this.setTooltipTextFromScout(action.getTooltipText());
        this.setEnabledFromScout(action.isEnabled());
    }

    protected void detachScout() {
        super.detachScout();
    }

    public Button getUiField() {
        return (Button)super.getUiField();
    }

    protected void setIconIdFromScout(String iconId) {
        if (iconId == null) {
            return;
        }
        Image icon = this.getUiEnvironment().getIcon(iconId);
        Button button = this.getUiField();
        button.setImage(icon);
    }

    protected void setTextFromScout(String text) {
        if (text == null) {
            text = "";
        }
        if (this.isEllipsisRemovalEnabled()) {
            text = this.removeEllipsis(text);
        }
        Button button = this.getUiField();
        button.setText(text);
    }

    protected String removeEllipsis(String text) {
        if (!StringUtility.hasText((CharSequence)text)) {
            return text;
        }
        if (text.endsWith("...")) {
            text = text.substring(0, text.length() - 3);
        }
        return text;
    }

    protected void setTooltipTextFromScout(String tooltipText) {
        this.getUiField().setToolTipText(tooltipText);
    }

    protected void setEnabledFromScout(boolean enabled) {
        this.getUiField().setEnabled(enabled);
    }

    public void setEllipsisRemovalEnabled(boolean ellipsisRemovalEnabled) {
        this.m_ellipsisRemovalEnabled = ellipsisRemovalEnabled;
    }

    public boolean isEllipsisRemovalEnabled() {
        return this.m_ellipsisRemovalEnabled;
    }

    protected void handleUiSelection() {
        if (this.hasChildActions()) {
            this.handleUiPopupMenu();
        } else {
            this.handleUiAction();
        }
    }

    protected void handleUiAction() {
        if (this.m_handleActionPending) {
            return;
        }
        this.m_handleActionPending = true;
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ((IAction)RwtScoutActionButton.this.getScoutObject()).getUIFacade().fireActionFromUI();
                }
                finally {
                    RwtScoutActionButton.this.m_handleActionPending = false;
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleUiPopupMenu() {
        Menu menu = this.createMenu();
        if (menu == null) {
            return;
        }
        if (!this.getUiField().getSelection()) {
            return;
        }
        menu.addMenuListener((MenuListener)new MenuAdapter(){
            private static final long serialVersionUID = 1L;

            public void menuHidden(MenuEvent e) {
                try {
                    if (!RwtScoutActionButton.this.getUiField().isFocusControl()) {
                        RwtScoutActionButton.this.getUiField().setSelection(false);
                    }
                }
                finally {
                    ((Menu)e.getSource()).removeMenuListener((MenuListener)this);
                }
            }
        });
        this.showMenu(menu);
    }

    private Menu createMenu() {
        if (this.getUiField().getMenu() != null) {
            this.getUiField().getMenu().dispose();
            this.getUiField().setMenu(null);
        }
        Menu contextMenu = new Menu((Decorations)this.getUiField().getShell(), 8);
        contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
        this.getUiField().setMenu(contextMenu);
        return contextMenu;
    }

    private void showMenu(Menu menu) {
        Point menuPosition = null;
        menuPosition = this.getMenuOpeningDirection() == 128 ? this.computeMenuPositionForTop(menu) : this.computeMenuPositionForBottom();
        this.showMenu(menu, menuPosition);
    }

    private void showMenu(Menu menu, Point location) {
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private Point computeMenuPositionForTop(Menu menu) {
        Rectangle buttonBounds = this.getUiField().getBounds();
        int menuLocationX = buttonBounds.x;
        int menuLocationY = buttonBounds.y - new MenuSizeEstimator(menu).estimateMenuHeight(this.getChildActions());
        return this.getUiField().getParent().toDisplay(menuLocationX, menuLocationY);
    }

    private Point computeMenuPositionForBottom() {
        Rectangle buttonBounds = this.getUiField().getBounds();
        int menuLocationX = buttonBounds.x;
        int menuLocationY = buttonBounds.y + buttonBounds.height;
        return this.getUiField().getParent().toDisplay(menuLocationX, menuLocationY);
    }

    public boolean hasChildActions() {
        return RwtMenuUtility.hasChildActions((IAction)((IAction)this.getScoutObject()));
    }

    private List<? extends IActionNode> getChildActions() {
        if (!(this.getScoutObject() instanceof IActionNode)) {
            return null;
        }
        IActionNode actionNode = (IActionNode)this.getScoutObject();
        if (!actionNode.hasChildActions()) {
            return null;
        }
        return actionNode.getChildActions();
    }

    @Override
    public int getMenuOpeningDirection() {
        return this.m_menuOpeningDirection;
    }

    @Override
    public void setMenuOpeningDirection(int menuOpeningDirection) {
        if (menuOpeningDirection != 128) {
            menuOpeningDirection = 1024;
        }
        this.m_menuOpeningDirection = menuOpeningDirection;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("iconId".equals(name)) {
            this.setIconIdFromScout((String)newValue);
        } else if ("text".equals(name)) {
            this.setTextFromScout((String)newValue);
        } else if ("tooltipText".equals(name)) {
            this.setTextFromScout((String)newValue);
        } else if ("enabled".equals(name)) {
            this.setEnabledFromScout((Boolean)newValue);
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapter {
        private static final long serialVersionUID = 1L;

        public void menuShown(MenuEvent e) {
            List actions = RwtScoutActionButton.this.getChildActions();
            if (actions == null) {
                return;
            }
            ArrayList<IMenu> scoutMenus = new ArrayList<IMenu>(actions.size());
            for (IActionNode a : actions) {
                if (!(a instanceof IMenu)) continue;
                scoutMenus.add((IMenu)a);
            }
            Menu menu = (Menu)e.getSource();
            RwtMenuUtility.fillMenu((Menu)menu, scoutMenus, (IActionFilter)ActionUtility.createVisibleFilter(), (IRwtEnvironment)RwtScoutActionButton.this.getUiEnvironment());
        }
    }

    private class P_RwtSelectionListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RwtScoutActionButton.this.handleUiSelection();
        }
    }
}

