/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.tabbox;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformationService;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.extension.IFormFieldFactory;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.tabbox.RwtScoutTabBox;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tabbox.RwtScoutMobileTabBox;
import org.eclipse.scout.rt.ui.rap.util.DeviceUtility;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.swt.widgets.Composite;

public class MobileTabBoxFactory
implements IFormFieldFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MobileTabBoxFactory.class);
    private IRwtEnvironment m_uiEnvironment;

    public IRwtScoutFormField<?> createUiFormField(Composite parent, IFormField model, IRwtEnvironment uiEnvironment) {
        this.m_uiEnvironment = uiEnvironment;
        ITabBox formField = (ITabBox)model;
        Object field = DeviceUtility.isMobileOrTabletDevice() && this.acceptMobileTabBoxTransformation(formField) ? new RwtScoutMobileTabBox() : new RwtScoutTabBox();
        field.createUiField(parent, (IPropertyObserver)formField, uiEnvironment);
        return field;
    }

    private boolean acceptMobileTabBoxTransformation(final ITabBox tabBox) {
        final BooleanHolder accepted = new BooleanHolder(Boolean.valueOf(false));
        ClientSyncJob job = new ClientSyncJob("Getting permission to create mobile tabbox.", this.m_uiEnvironment.getClientSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                IDeviceTransformationService service = (IDeviceTransformationService)SERVICES.getService(IDeviceTransformationService.class);
                if (service == null || service.getDeviceTransformer() == null) {
                    return;
                }
                accepted.setValue((Object)service.getDeviceTransformer().acceptMobileTabBoxTransformation(tabBox));
            }
        };
        job.schedule();
        try {
            job.join(5000L);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to getting permission to create mobile tabbox.", (Throwable)e);
        }
        return (Boolean)accepted.getValue();
    }
}

