/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.concurrency;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.concurrency.LoopDetector;
import org.eclipse.swt.widgets.Display;

public class RwtScoutSynchronizer {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutSynchronizer.class);
    private final IRwtEnvironment m_uiEnvironment;
    private final Display m_rwtQueue;
    private final LoopDetector m_loopDetector;

    public RwtScoutSynchronizer(IRwtEnvironment uiEnvironment) {
        this.m_uiEnvironment = uiEnvironment;
        this.m_rwtQueue = this.m_uiEnvironment.getDisplay();
        this.m_loopDetector = new LoopDetector(5000L, 2500, 10);
    }

    private boolean isModelThread() {
        return ClientSyncJob.getCurrentSession() == this.m_uiEnvironment.getClientSession() && ClientSyncJob.isSyncClientJob();
    }

    public JobEx invokeScoutLater(final Runnable j, long cancelTimeout) {
        if (this.isModelThread()) {
            LOG.warn("queueing scout runnable into scout thread: " + j);
            j.run();
            return null;
        }
        if (Thread.currentThread() != this.m_rwtQueue.getThread()) {
            throw new IllegalStateException("queueing scout runnable from outside rwt thread: " + j);
        }
        this.m_loopDetector.addSample();
        if (this.m_loopDetector.isArmed()) {
            LOG.warn("loop detection: " + j, (Throwable)new Exception("Loop detected"));
            return null;
        }
        final long deadLine = cancelTimeout > 0L ? System.currentTimeMillis() + cancelTimeout : -1L;
        ClientSyncJob eclipseJob = new ClientSyncJob("rwt post::" + j, this.m_uiEnvironment.getClientSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (deadLine < 0L || deadLine > System.currentTimeMillis()) {
                    j.run();
                }
            }
        };
        eclipseJob.schedule();
        return eclipseJob;
    }

    public void invokeUiLater(Runnable j) {
        IClientSession uiClientSession;
        if (this.m_rwtQueue.isDisposed()) {
            return;
        }
        if (Thread.currentThread() == this.m_rwtQueue.getThread()) {
            LOG.warn("queueing rwt runnable into rwt thread: " + j);
            j.run();
            return;
        }
        IClientSession currentSession = ClientSyncJob.getCurrentSession();
        if (currentSession != (uiClientSession = this.m_uiEnvironment.getClientSession())) {
            String currentUserId = currentSession == null ? "" : currentSession.getUserId();
            String currentWebSessionId = currentSession == null ? "" : currentSession.getVirtualSessionId();
            String uiClientUserId = uiClientSession == null ? "" : uiClientSession.getUserId();
            String uiClientWebSessionId = uiClientSession == null ? "" : uiClientSession.getVirtualSessionId();
            LOG.error("Wrong ClientSession.\nCurrentSession:           {0}\tUserId: {2}\tWebSesionId: {3}\nEnvironmentClientSession: {4}\tUserId: {5}\tWebSesionId: {5}", new Object[]{currentSession == null ? "" : currentSession, currentUserId, currentWebSessionId, uiClientSession == null ? "" : uiClientSession, uiClientUserId, uiClientWebSessionId});
            throw new IllegalStateException("queueing rwt runnable from outside scout thread: " + j);
        }
        if (!this.isModelThread()) {
            throw new IllegalStateException("queueing rwt runnable from outside scout thread: " + j);
        }
        this.m_rwtQueue.asyncExec(j);
    }
}

