/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.html;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.html.HyperlinkParser;
import org.eclipse.scout.rt.ui.rap.html.IHyperlinkProcessor;
import org.eclipse.scout.rt.ui.rap.html.TargetRwtInjectingHyperlinkProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Label;

public class HtmlAdapter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(HtmlAdapter.class);
    private IRwtEnvironment m_uiEnvironment;
    private HyperlinkParser m_hyperlinkParser;
    private static final Pattern imageCidPattern = Pattern.compile("(['\"(])(cid:)([^()\"']*)([)'\"])", 2);
    private static final Pattern tableTagPattern = Pattern.compile("<table([^>]*)>", 34);
    private static final Pattern styleAttributePattern = Pattern.compile("style\\s*=\\s*\"([^\"]*)\"", 34);

    public HtmlAdapter(IRwtEnvironment uiEnvironment) {
        this.m_uiEnvironment = uiEnvironment;
        this.m_hyperlinkParser = new HyperlinkParser();
    }

    public String adaptHtmlCell(IRwtScoutComposite<?> uiComposite, String rawHtml) {
        FontData[] fa;
        int size = 12;
        if (uiComposite.getUiField() != null && (fa = uiComposite.getUiField().getFont().getFontData()) != null && fa.length > 0 && fa[0].getHeight() > 0) {
            size = fa[0].getHeight();
        }
        String stylePrefix = "color:inherit;background-color:inherit;font-size:" + size + "px;";
        rawHtml = this.bugfixStyles(rawHtml, stylePrefix);
        rawHtml = this.replaceImageCids(rawHtml);
        return rawHtml;
    }

    protected String replaceImageCids(String rawHtml) {
        if (rawHtml == null) {
            return null;
        }
        try {
            Matcher m = imageCidPattern.matcher(rawHtml);
            while (m.find()) {
                String cidMarker = m.group(2);
                String imageName = m.group(3);
                String location = this.resolveImageResourceName(imageName);
                if (location != null) {
                    rawHtml = rawHtml.replace(String.valueOf(m.group(1)) + cidMarker + imageName + m.group(4), String.valueOf(m.group(1)) + location + m.group(4));
                    continue;
                }
                LOG.warn("Image resource name could not be resolved. Image: " + imageName);
            }
        }
        catch (IOException e) {
            LOG.error("Exception occured while replacing image cids.", (Throwable)e);
        }
        return rawHtml;
    }

    protected String resolveImageResourceName(String imageName) throws IOException {
        Image image = this.m_uiEnvironment.getIcon(imageName);
        if (image == null) {
            return null;
        }
        ResourceManager resourceManager = RWT.getResourceManager();
        return resourceManager.getLocation(image.internalImage.getResourceName());
    }

    private String bugfixStyles(String html, String stylePrefix) {
        Matcher m = tableTagPattern.matcher(html);
        StringBuilder buf = new StringBuilder();
        int lastPos = 0;
        while (m.find()) {
            buf.append(html.substring(lastPos, m.start()));
            String atts = m.group(1);
            Matcher m2 = styleAttributePattern.matcher(atts);
            if (m2.find()) {
                buf.append(html.substring(m.start(), m.start(1) + m2.start(1)));
                buf.append(stylePrefix);
                buf.append(html.substring(m.start(1) + m2.start(1), m.end()));
            } else {
                buf.append(html.substring(m.start(), m.start(1)));
                buf.append(" style=\"");
                buf.append(stylePrefix);
                buf.append("\" ");
                buf.append(html.substring(m.start(1), m.end()));
            }
            lastPos = m.end();
        }
        if (lastPos < html.length()) {
            buf.append(html.substring(lastPos));
        }
        return buf.toString();
    }

    public String convertLinksInHtmlCell(IRwtScoutComposite<?> uiComposite, String rawHtml) {
        return this.convertLinksInHtmlCell(uiComposite, rawHtml, null);
    }

    public String convertLinksInHtmlCell(IRwtScoutComposite<?> uiComposite, String rawHtml, Map<String, String> additionalParams) {
        return this.processHyperlinks(rawHtml, new TargetRwtInjectingHyperlinkProcessor(additionalParams));
    }

    public String processHyperlinks(String html, IHyperlinkProcessor processor) {
        return this.m_hyperlinkParser.parse(html, processor);
    }

    public String styleHtmlText(IRwtScoutFormField<?> uiComposite, String rawHtml) {
        if (rawHtml == null) {
            rawHtml = "";
        }
        String cleanHtml = rawHtml;
        if (uiComposite.getScoutObject() instanceof IHtmlField) {
            IHtmlField htmlField = (IHtmlField)uiComposite.getScoutObject();
            if (htmlField.isHtmlEditor()) {
                if (!StringUtility.hasText((CharSequence)cleanHtml)) {
                    cleanHtml = "<html><head></head><body></body></html>";
                }
            } else {
                Color c = this.m_uiEnvironment.getFormToolkit().getHyperlinkGroup().getForeground();
                java.awt.Color hyperlinkColor = new java.awt.Color(c.getRed(), c.getGreen(), c.getBlue());
                cleanHtml = HTMLUtility.cleanupHtml((String)cleanHtml, (boolean)true, (boolean)false, (HTMLUtility.DefaultFont)this.createDefaultFontSettings(uiComposite), (java.awt.Color)hyperlinkColor);
            }
        }
        return cleanHtml;
    }

    public HTMLUtility.DefaultFont createDefaultFontSettings(IRwtScoutFormField<?> uiComposite) {
        HTMLUtility.DefaultFont defaultFont = new HTMLUtility.DefaultFont();
        defaultFont.setSize(12);
        defaultFont.setSizeUnit("px");
        defaultFont.setForegroundColor(0);
        defaultFont.setFamilies(new String[]{"sans-serif"});
        if (uiComposite != null && uiComposite.getUiField() != null) {
            Color color;
            FontData[] fontData = uiComposite.getUiField().getFont().getFontData();
            if (fontData == null || fontData.length <= 0) {
                Label label = new Label(uiComposite.getUiContainer(), 0);
                fontData = label.getFont().getFontData();
                label.dispose();
            }
            if (fontData != null && fontData.length > 0) {
                String fontFamily;
                int height = fontData[0].getHeight();
                if (height > 0) {
                    defaultFont.setSize(height);
                }
                if (StringUtility.hasText((CharSequence)(fontFamily = fontData[0].getName()))) {
                    defaultFont.setFamilies(new String[]{fontFamily, "sans-serif"});
                }
            }
            if ((color = uiComposite.getUiField().getForeground()) != null) {
                defaultFont.setForegroundColor(color.getRed() * 65536 + color.getGreen() * 256 + color.getBlue());
            }
        }
        return defaultFont;
    }
}

