/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.patches;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;

public final class PatchInstaller {
    private PatchInstaller() {
    }

    public static void install(URL url) {
        PatchInstaller.ensureRegistered(url);
        PatchInstaller.ensureLoaded(url);
    }

    private static void ensureRegistered(URL url) {
        String identifier = PatchInstaller.toIdentifier(url);
        if (!RWT.getResourceManager().isRegistered(identifier)) {
            try (InputStream is = url.openStream();){
                RWT.getResourceManager().register(identifier, is);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to register patch: " + url, e);
            }
        }
    }

    private static void ensureLoaded(URL url) {
        JavaScriptLoader loader = (JavaScriptLoader)RWT.getClient().getService(JavaScriptLoader.class);
        loader.require(RWT.getResourceManager().getLocation(PatchInstaller.toIdentifier(url)));
    }

    private static String toIdentifier(URL url) {
        return url.getPath();
    }
}

