/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import java.util.HashMap;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ColorFactory.class);
    private final Display m_display;
    private HashMap<String, Color> m_colorCache = new HashMap();

    public ColorFactory(Display display) {
        this.m_display = display;
    }

    public Color getColor(RGB rgb) {
        int iRgb = (rgb.red & 0xFF) << 16 | (rgb.green & 0xFF) << 8 | (rgb.blue & 0xFF) << 0;
        String hexString = Integer.toHexString(iRgb);
        while (hexString.length() < 6) {
            hexString = "0" + hexString;
        }
        return this.getColor(hexString);
    }

    public Color getColor(String scoutColor) {
        if (scoutColor == null || scoutColor.length() != 6) {
            return null;
        }
        Color c = this.m_colorCache.get(scoutColor);
        if (c == null) {
            c = this.createColorFromScout(scoutColor);
            this.m_colorCache.put(scoutColor, c);
        }
        return c;
    }

    private Color createColorFromScout(String scoutColor) {
        if (scoutColor == null) {
            return null;
        }
        if (!scoutColor.matches("(|[A-Fa-f0-9]{6})")) {
            LOG.warn("undefined color string '" + scoutColor + "'");
            return null;
        }
        int i = Integer.parseInt(scoutColor, 16);
        RGB rgb = new RGB(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
        return new Color((Device)this.m_display, rgb);
    }

    public void dispose() {
        for (Color c : this.m_colorCache.values()) {
            if (c == null || c.isDisposed() || c.getDevice() == null) continue;
            c.dispose();
        }
        this.m_colorCache.clear();
    }
}

