/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service.internal;

import org.eclipse.scout.commons.holders.HolderUtility;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.holders.NVPair;

public abstract class AbstractHolderArgumentVisitor {
    public abstract void visitHolder(IHolder<?> var1, IHolder<?> var2);

    public abstract void visitOther(Object[] var1, Object[] var2, int var3);

    public void startVisiting(Object[] input, Object[] output, int maxDepth, boolean autoCreateOutputStructure) {
        this.visitImpl(input, output, 0, maxDepth, autoCreateOutputStructure);
    }

    private void visitImpl(Object[] input, Object[] output, int depth, int maxDepth, boolean autoCreateOutputStructure) {
        int i = 0;
        while (i < input.length) {
            if (this.isObjectArray(input[i]) && this.isObjectArray(output[i])) {
                if (depth < maxDepth) {
                    this.visitImpl((Object[])input[i], (Object[])output[i], depth + 1, maxDepth, autoCreateOutputStructure);
                } else {
                    this.visitOther(input, output, i);
                }
            } else if (this.isObjectArray(input[i])) {
                if (depth < maxDepth) {
                    if (output[i] == null && autoCreateOutputStructure) {
                        output[i] = new Object[((Object[])input[i]).length];
                        this.visitImpl((Object[])input[i], (Object[])output[i], depth + 1, maxDepth, autoCreateOutputStructure);
                    }
                } else {
                    this.visitOther(input, output, i);
                }
            } else if (input[i] instanceof IHolder) {
                if (output[i] == null && autoCreateOutputStructure) {
                    output[i] = HolderUtility.createSerializableHolder((IHolder)((IHolder)input[i]));
                }
                if (output[i] instanceof IHolder) {
                    this.visitHolder((IHolder)input[i], (IHolder)output[i]);
                } else {
                    this.visitOther(input, output, i);
                }
            } else if (input[i] instanceof NVPair && ((NVPair)input[i]).getValue() instanceof IHolder) {
                NVPair nv = (NVPair)input[i];
                if (output[i] == null && autoCreateOutputStructure) {
                    output[i] = new NVPair(nv.getName(), (Object)HolderUtility.createSerializableHolder((IHolder)((IHolder)nv.getValue())));
                }
                if (output[i] instanceof NVPair && ((NVPair)output[i]).getValue() instanceof IHolder) {
                    this.visitHolder((IHolder)((NVPair)input[i]).getValue(), (IHolder)((NVPair)output[i]).getValue());
                } else {
                    this.visitOther(input, output, i);
                }
            } else {
                this.visitOther(input, output, i);
            }
            ++i;
        }
    }

    private boolean isObjectArray(Object o) {
        return o != null && o.getClass() == Object[].class;
    }
}

