/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.internal.java;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class LogRecorderHandler
extends FileHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LogRecorderHandler.class);
    private String m_logDirectory;

    public LogRecorderHandler(String logDirectory, int limit, int count, boolean append) throws SecurityException, IOException {
        super(String.valueOf(logDirectory) + "/log_%u%g.log", limit, count, append);
        this.m_logDirectory = logDirectory;
    }

    public File getLogFile() {
        try {
            File zipFile = IOUtility.createTempFile("logging.zip", null);
            FileUtility.compressArchive(IOUtility.toFile(this.m_logDirectory), zipFile);
            return zipFile;
        }
        catch (Exception e) {
            LOG.error("could not pack log files into ZIP archive", e);
            return null;
        }
    }

    public String getLogDirectory() {
        return this.m_logDirectory;
    }
}

