/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.services.common.perf.IPerformanceAnalyzerService;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCloseButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.shared.services.common.shell.IShellService;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Version;

public class ScoutInfoForm
extends AbstractForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ScoutInfoForm.class);
    private RemoteFile m_logoImage = new RemoteFile("logo.png", 0L);

    public RemoteFile getLogoImage() {
        return this.m_logoImage;
    }

    public void setLogoImage(RemoteFile f) {
        this.m_logoImage = f;
    }

    @Override
    protected String getConfiguredTitle() {
        return ScoutTexts.get((String)"Info", (String[])new String[0]);
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.GroupBox.HtmlField getHtmlField() {
        return this.getFieldByClass(MainBox.GroupBox.HtmlField.class);
    }

    public MainBox.CloseButton getCloseButton() {
        return this.getFieldByClass(MainBox.CloseButton.class);
    }

    public void startModify() throws ProcessingException {
        this.startInternal(new ModifyHandler());
    }

    protected void createHtmlAttachments(Collection<RemoteFile> collection) {
        RemoteFile f = this.getLogoImage();
        if (f != null && !f.hasContent()) {
            try {
                IClientSession clientSession = ClientSyncJob.getCurrentSession();
                IconSpec iconSpec = clientSession.getIconLocator().getIconSpec("application_logo_large");
                ByteArrayInputStream is = new ByteArrayInputStream(iconSpec.getContent());
                f.readData((InputStream)is);
                is.close();
            }
            catch (Exception ex2) {
                LOG.info(null, (Throwable)ex2);
                f = null;
            }
        }
        if (f != null && f.hasContent()) {
            collection.add(f);
        }
    }

    protected void createHtmlBody(StringBuffer buf) {
        String title = "unknown";
        Version v = Version.emptyVersion;
        IProduct product = Platform.getProduct();
        if (product != null) {
            title = product.getName();
            v = Version.parseVersion((String)((String)product.getDefiningBundle().getHeaders().get("Bundle-Version")));
        }
        buf.append("<head>\n");
        buf.append("<style type=\"text/css\">\n");
        buf.append("h1 {font-family: sans-serif}\n");
        buf.append("h2 {font-family: sans-serif}\n");
        buf.append("h3 {font-family: sans-serif}\n");
        buf.append("body {font-family: sans-serif}\n");
        buf.append("p {font-family: sans-serif}\n");
        buf.append("</style>\n");
        buf.append("</head>\n");
        buf.append("<p>");
        RemoteFile f = this.getLogoImage();
        if (f != null) {
            buf.append("<img src=\"" + f.getPath() + "\">");
        } else {
            buf.append("<h3>" + title + "</h3>");
        }
        buf.append("<p>");
        buf.append("<h2>" + title + " " + v.getMajor() + "." + v.getMinor() + "." + v.getMicro() + "</h2>");
        buf.append("<table cellspacing=0 cellpadding=0>");
        StringBuffer contentBuf = new StringBuffer();
        this.createHtmlPropertyTableContent(contentBuf);
        buf.append(contentBuf.toString());
        buf.append("<tr><td>" + ScoutTexts.get((String)"DetailedVersion", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + v.toString() + "</td></tr>");
        buf.append("</table>");
    }

    protected void createHtmlPropertyTableContent(StringBuffer buf) {
        IClientSession session = ClientSyncJob.getCurrentSession();
        long memUsed = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
        long memTotal = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        long memMax = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        buf.append("<tr><td>" + ScoutTexts.get((String)"Username", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + session.getUserId() + "</td></tr>");
        buf.append("<tr><td>" + ScoutTexts.get((String)"Language", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + LocaleThreadLocal.get().getDisplayLanguage() + "</td></tr>");
        buf.append("<tr><td>" + ScoutTexts.get((String)"FormattingLocale", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + LocaleThreadLocal.get() + "</td></tr>");
        if (UserAgentUtility.isRichClient()) {
            buf.append("<tr><td>" + ScoutTexts.get((String)"JavaVersion", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + System.getProperty("java.version") + "</td></tr>");
            buf.append("<tr><td>" + ScoutTexts.get((String)"JavaVMVersion", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + System.getProperty("java.vm.version") + "</td></tr>");
            buf.append("<tr><td>" + ScoutTexts.get((String)"OSVersion", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "</td></tr>");
            buf.append("<tr><td>" + ScoutTexts.get((String)"OSUser", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + System.getProperty("user.name") + "</td></tr>");
            buf.append("<tr><td>" + ScoutTexts.get((String)"MemoryStatus", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + memUsed + "MB (total " + memTotal + "MB / max " + memMax + "MB)</td></tr>");
            IPerformanceAnalyzerService perf = (IPerformanceAnalyzerService)SERVICES.getService(IPerformanceAnalyzerService.class);
            if (perf != null) {
                buf.append("<tr><td>" + ScoutTexts.get((String)"NetworkLatency", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + perf.getNetworkLatency() + " ms</td></tr>");
                buf.append("<tr><td>" + ScoutTexts.get((String)"ExecutionTime", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + perf.getServerExecutionTime() + " ms</td></tr>");
            }
            if (session.getServiceTunnel() != null) {
                buf.append("<tr><td>" + ScoutTexts.get((String)"Server", (String[])new String[0]) + ":</td><td>&nbsp;</td><td>" + session.getServiceTunnel().getServerURL() + "</td></tr>");
            }
        }
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return UserAgentUtility.isSwingUi();
        }

        @Order(value=20.0)
        public class CloseButton
        extends AbstractCloseButton {
            @Override
            protected String getConfiguredTooltipText() {
                return null;
            }
        }

        @Order(value=10.0)
        public class GroupBox
        extends AbstractGroupBox {
            @Override
            protected boolean getConfiguredGridUseUiWidth() {
                return UserAgentUtility.isSwingUi();
            }

            @Order(value=10.0)
            public class HtmlField
            extends AbstractHtmlField {
                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected boolean getConfiguredEnabled() {
                    return true;
                }

                @Override
                protected boolean getConfiguredScrollBarEnabled() {
                    return false;
                }

                @Override
                protected boolean getConfiguredGridUseUiWidth() {
                    return UserAgentUtility.isSwingUi();
                }

                @Override
                protected boolean getConfiguredGridUseUiHeight() {
                    return UserAgentUtility.isSwingUi();
                }

                @Override
                protected int getConfiguredGridW() {
                    if (UserAgentUtility.isSwingUi()) {
                        return 1;
                    }
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    if (UserAgentUtility.isSwingUi()) {
                        return 1;
                    }
                    if (UserAgentUtility.isWebClient()) {
                        return 12;
                    }
                    return 20;
                }

                @Override
                protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
                    if (!local) {
                        ((IShellService)SERVICES.getService(IShellService.class)).shellOpen(url.toExternalForm());
                    }
                }
            }
        }
    }

    @Order(value=20.0)
    public class ModifyHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
            ArrayList<RemoteFile> attachments = new ArrayList<RemoteFile>();
            ScoutInfoForm.this.createHtmlAttachments(attachments);
            if (attachments.size() > 0) {
                ScoutInfoForm.this.getHtmlField().setAttachments(attachments);
            }
            StringBuffer buf = new StringBuffer();
            ScoutInfoForm.this.createHtmlBody(buf);
            ScoutInfoForm.this.getHtmlField().setValue(buf.toString());
        }
    }
}

