/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.internal;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.TypeCastUtility;

public abstract class AbstractCompositeExtensionFilter<T> {
    private final List<T> m_filters = new LinkedList<T>();

    public AbstractCompositeExtensionFilter(T ... filters) {
        if (filters != null) {
            T[] TArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                T f = TArray[n2];
                this.addFilter(f);
                ++n2;
            }
        }
    }

    public boolean addFilter(T filter) {
        if (filter == null) {
            return false;
        }
        return this.m_filters.add(filter);
    }

    public boolean addFilterAtBegin(T filter) {
        if (filter == null) {
            return false;
        }
        this.m_filters.add(0, filter);
        return true;
    }

    public boolean removeFilter(T filter) {
        return this.m_filters.remove(filter);
    }

    public boolean isEmpty() {
        return this.m_filters.isEmpty();
    }

    public int size() {
        return this.m_filters.size();
    }

    public T[] getFilters() {
        Class typeParameter = TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractCompositeExtensionFilter.class);
        Object[] result = (Object[])Array.newInstance(typeParameter, this.m_filters.size());
        if (result.length == 0) {
            return result;
        }
        return this.m_filters.toArray(result);
    }
}

