/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.security;

import java.security.Permission;
import java.util.regex.Pattern;

public class RemoteServiceAccessPermission
extends Permission {
    private static final long serialVersionUID = 1L;
    private transient Pattern m_pattern;

    public RemoteServiceAccessPermission(String interfaceTypeName, String methodName) {
        super(String.valueOf(interfaceTypeName.replace('$', '.')) + "#" + methodName);
    }

    @Override
    public boolean implies(Permission p) {
        if (p == null || p.getClass() != this.getClass()) {
            return false;
        }
        if (this.m_pattern == null) {
            this.m_pattern = Pattern.compile(this.getName().replace(".", "[.]").replace("*", ".*"));
        }
        RemoteServiceAccessPermission other = (RemoteServiceAccessPermission)p;
        return this.m_pattern.matcher(other.getName()).matches();
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteServiceAccessPermission)) {
            return false;
        }
        return ((RemoteServiceAccessPermission)obj).getName().equals(this.getName());
    }

    @Override
    public String getActions() {
        return null;
    }
}

