/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IntegerHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.extension.AbstractSerializableExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.extension.services.common.code.CodeTypeWithGenericChains;
import org.eclipse.scout.rt.shared.extension.services.common.code.ICodeTypeExtension;
import org.eclipse.scout.rt.shared.extension.services.common.code.MoveCodesHandler;
import org.eclipse.scout.rt.shared.services.common.code.AbstractCode;
import org.eclipse.scout.rt.shared.services.common.code.CodeRow;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeRow;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.common.code.MutableCode;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE extends ICode<CODE_ID>>
implements ICodeType<CODE_TYPE_ID, CODE_ID>,
IContributionOwner,
IExtensibleObject,
Serializable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCodeTypeWithGeneric.class);
    private static final long serialVersionUID = 1L;
    private boolean m_initialized;
    private String m_text;
    private String m_iconId;
    private boolean m_hierarchy;
    private int m_maxLevel;
    private transient Map<CODE_ID, CODE> m_rootCodeMap = new HashMap<CODE_ID, CODE>();
    private List<CODE> m_rootCodeList = new ArrayList<CODE>();
    protected IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>, ICodeTypeExtension<CODE_TYPE_ID, CODE_ID, ? extends AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>>> m_objectExtensions = new ObjectExtensions(this);

    public AbstractCodeTypeWithGeneric() {
        this(true);
    }

    public AbstractCodeTypeWithGeneric(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    @Override
    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    @Override
    public final <T> T getContribution(Class<T> contribution) {
        return this.m_contributionHolder.getContribution(contribution);
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.m_initialized = true;
        }
    }

    public AbstractCodeTypeWithGeneric(String label, boolean hierarchy) {
        this.m_text = label;
        this.m_hierarchy = hierarchy;
    }

    protected final List<Class<ICode>> getConfiguredCodes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, ICode.class);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredIsHierarchy() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=30.0)
    protected int getConfiguredMaxLevel() {
        return Integer.MAX_VALUE;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=40.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="CODE_ROW")
    @Order(value=120.0)
    protected Class<? extends ICodeRow<CODE_ID>> getConfiguredCodeRowType() {
        return CodeRow.class;
    }

    @ConfigOperation
    @Order(value=1.0)
    protected List<? extends CODE> execCreateCodes() throws ProcessingException {
        List<Class<ICode>> configuredCodes = this.getConfiguredCodes();
        List<ICode> contributedCodes = this.m_contributionHolder.getContributionsByClass(ICode.class);
        OrderedCollection codes = new OrderedCollection();
        for (Class<ICode> codeClazz : configuredCodes) {
            try {
                ICode code = (ICode)ConfigurationUtility.newInnerInstance((Object)this, codeClazz);
                codes.addOrdered((IOrdered)code);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + codeClazz.getName() + "'.", (Throwable)e));
            }
        }
        for (ICode c : contributedCodes) {
            codes.addOrdered((IOrdered)c);
        }
        new MoveCodesHandler(codes).moveModelObjects();
        return codes.getOrderedList();
    }

    @ConfigOperation
    @Order(value=2.0)
    protected CODE execCreateCode(ICodeRow<CODE_ID> newRow) throws ProcessingException {
        Class codeClazz = TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractCodeTypeWithGeneric.class, (int)2);
        if (!Modifier.isAbstract(codeClazz.getModifiers()) && !Modifier.isInterface(codeClazz.getModifiers())) {
            Class<ICodeRow<CODE_ID>> codeRowClazz = this.getConfiguredCodeRowType();
            try {
                Constructor ctor = codeClazz.getConstructor(codeRowClazz);
                return (CODE)((ICode)ctor.newInstance(newRow));
            }
            catch (Exception e) {
                throw new ProcessingException("Could not create a new instance of code row! Override the execCreateCode mehtod.", (Throwable)e);
            }
        }
        if (codeClazz.isAssignableFrom(MutableCode.class)) {
            return (CODE)new MutableCode<CODE_ID>(newRow);
        }
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected List<? extends ICodeRow<CODE_ID>> execLoadCodes(Class<? extends ICodeRow<CODE_ID>> codeRowType) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execOverwriteCode(ICodeRow<CODE_ID> oldCode, ICodeRow<CODE_ID> newCode) throws ProcessingException {
        if (newCode.getBackgroundColor() == null) {
            newCode.setBackgroundColor(oldCode.getBackgroundColor());
        }
        if (newCode.getFont() == null) {
            newCode.setFont(oldCode.getFont());
        }
        if (newCode.getForegroundColor() == null) {
            newCode.setForegroundColor(oldCode.getForegroundColor());
        }
        if (newCode.getIconId() == null) {
            newCode.setIconId(oldCode.getIconId());
        }
        if (newCode.getExtKey() == null) {
            newCode.setExtKey(oldCode.getExtKey());
        }
        if (newCode.getValue() == null) {
            newCode.setValue(oldCode.getValue());
        }
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractCodeTypeWithGeneric.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.m_text = this.getConfiguredText();
        this.m_iconId = this.getConfiguredIconId();
        this.m_hierarchy = this.getConfiguredIsHierarchy();
        this.m_maxLevel = this.getConfiguredMaxLevel();
        this.m_contributionHolder = new ContributionComposite(this);
        try {
            this.loadCodes();
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get("CodeTypeInit", new String[0])) + " " + this.m_text);
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    protected ICodeTypeExtension<CODE_TYPE_ID, CODE_ID, ? extends AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>> createLocalExtension() {
        return new LocalCodeTypeWithGenericExtension(this);
    }

    public final List<? extends ICodeTypeExtension<CODE_TYPE_ID, CODE_ID, ? extends AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <E extends IExtension<?>> E getExtension(Class<E> c) {
        return this.m_objectExtensions.getExtension(c);
    }

    protected final List<? extends CODE> interceptCreateCodes() throws ProcessingException {
        List<ICodeTypeExtension<CODE_TYPE_ID, CODE_ID, AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>>> extensions = this.getAllExtensions();
        CodeTypeWithGenericChains.CodeTypeWithGenericCreateCodesChain chain = new CodeTypeWithGenericChains.CodeTypeWithGenericCreateCodesChain(extensions);
        return chain.execCreateCodes();
    }

    protected final CODE interceptCreateCode(ICodeRow<CODE_ID> newRow) throws ProcessingException {
        List<ICodeTypeExtension<CODE_TYPE_ID, CODE_ID, AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>>> extensions = this.getAllExtensions();
        CodeTypeWithGenericChains.CodeTypeWithGenericCreateCodeChain chain = new CodeTypeWithGenericChains.CodeTypeWithGenericCreateCodeChain(extensions);
        return chain.execCreateCode(newRow);
    }

    protected List<? extends ICodeRow<CODE_ID>> interceptLoadCodes(Class<? extends ICodeRow<CODE_ID>> codeRowType) throws ProcessingException {
        List<ICodeTypeExtension<CODE_TYPE_ID, CODE_ID, AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>>> extensions = this.getAllExtensions();
        CodeTypeWithGenericChains.CodeTypeWithGenericLoadCodesChain chain = new CodeTypeWithGenericChains.CodeTypeWithGenericLoadCodesChain(extensions);
        return chain.execLoadCodes(codeRowType);
    }

    protected void interceptOverwriteCode(ICodeRow<CODE_ID> oldCode, ICodeRow<CODE_ID> newCode) throws ProcessingException {
        List<ICodeTypeExtension<CODE_TYPE_ID, CODE_ID, AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>>> extensions = this.getAllExtensions();
        CodeTypeWithGenericChains.CodeTypeWithGenericOverwriteCodeChain chain = new CodeTypeWithGenericChains.CodeTypeWithGenericOverwriteCodeChain(extensions);
        chain.execOverwriteCode(oldCode, newCode);
    }

    @Override
    public abstract CODE_TYPE_ID getId();

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public boolean isHierarchy() {
        return this.m_hierarchy;
    }

    @Override
    public int getMaxLevel() {
        return this.m_maxLevel;
    }

    public CODE getCode(CODE_ID id) {
        ICode<CODE_ID> c = (ICode<CODE_ID>)this.m_rootCodeMap.get(id);
        if (c == null) {
            for (ICode childCode : this.m_rootCodeList) {
                c = childCode.getChildCode(id);
                if (c == null) continue;
                return (CODE)c;
            }
        }
        return (CODE)c;
    }

    public CODE getCodeByExtKey(Object extKey) {
        ICode c = null;
        for (ICode childCode : this.m_rootCodeList) {
            c = extKey.equals(childCode.getExtKey()) ? childCode : childCode.getChildCodeByExtKey(extKey);
            if (c == null) continue;
            return (CODE)c;
        }
        return (CODE)c;
    }

    @Override
    public int getCodeIndex(final CODE_ID id) {
        final IntegerHolder result = new IntegerHolder(Integer.valueOf(-1));
        ICodeVisitor v = new ICodeVisitor<ICode<CODE_ID>>(){
            private int index = 0;

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                if (CompareUtility.equals(code.getId(), (Object)id)) {
                    result.setValue((Object)this.index);
                } else {
                    ++this.index;
                }
                return (Integer)result.getValue() < 0;
            }
        };
        this.visit(v, false);
        return (Integer)result.getValue();
    }

    @Override
    public int getCodeIndex(final ICode<CODE_ID> c) {
        final IntegerHolder result = new IntegerHolder(Integer.valueOf(-1));
        ICodeVisitor v = new ICodeVisitor<ICode<CODE_ID>>(){
            private int index = 0;

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                if (code == c) {
                    result.setValue((Object)this.index);
                } else {
                    ++this.index;
                }
                return (Integer)result.getValue() < 0;
            }
        };
        this.visit(v, false);
        return (Integer)result.getValue();
    }

    @Override
    public List<? extends CODE> getCodes() {
        return this.getCodes(true);
    }

    @Override
    public List<? extends CODE> getCodes(boolean activeOnly) {
        ArrayList<CODE> list = new ArrayList<CODE>(this.m_rootCodeList);
        if (activeOnly) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ICode code = (ICode)it.next();
                if (code.isActive()) continue;
                it.remove();
            }
        }
        return list;
    }

    protected void loadCodes() throws ProcessingException {
        List<ICodeRow<CODE_ID>> result;
        this.m_rootCodeMap = new HashMap<CODE_ID, CODE>();
        this.m_rootCodeList = new ArrayList<CODE>();
        ArrayList<ICode> allCodesOrdered = new ArrayList<ICode>();
        HashMap<ICode, ICode> codeToParentCodeMap = new HashMap<ICode, ICode>();
        HashMap idToCodeMap = new HashMap();
        List<CODE> createdList = this.interceptCreateCodes();
        if (createdList != null) {
            for (ICode code : createdList) {
                allCodesOrdered.add(code);
                idToCodeMap.put(code.getId(), code);
                codeToParentCodeMap.put(code, null);
            }
        }
        if ((result = this.interceptLoadCodes(this.getConfiguredCodeRowType())) != null && result.size() > 0) {
            HashMap codeToParentIdMap = new HashMap();
            for (ICodeRow<CODE_ID> newRow : result) {
                CODE newCode;
                ICode existingCode = (ICode)idToCodeMap.get(newRow.getKey());
                if (existingCode != null) {
                    this.interceptOverwriteCode(existingCode.toCodeRow(), newRow);
                }
                if ((newCode = this.interceptCreateCode(newRow)) != null) {
                    if (existingCode != null) {
                        allCodesOrdered.remove(existingCode);
                        idToCodeMap.remove(existingCode.getId());
                        codeToParentCodeMap.remove(existingCode);
                    }
                    allCodesOrdered.add((ICode)newCode);
                    idToCodeMap.put(newCode.getId(), (ICode<Object>)newCode);
                    Object parentId = newRow.getParentKey();
                    codeToParentIdMap.put(newCode, parentId);
                    continue;
                }
                if (existingCode == null) continue;
                allCodesOrdered.remove(existingCode);
                allCodesOrdered.add(existingCode);
            }
            for (Map.Entry e : codeToParentIdMap.entrySet()) {
                ICode code = (ICode)e.getKey();
                Object parentId = e.getValue();
                ICode parentCode = null;
                if (parentId != null && (parentCode = (ICode)idToCodeMap.get(parentId)) == null) {
                    LOG.warn("parent code for " + code + " not found: id=" + parentId);
                }
                codeToParentCodeMap.put(code, parentCode);
            }
        }
        for (ICode code : allCodesOrdered) {
            ICode parentCode = (ICode)codeToParentCodeMap.get(code);
            if (parentCode != null) {
                parentCode.addChildCodeInternal(-1, code);
                continue;
            }
            this.addRootCodeInternal(-1, code);
        }
        this.visit(new ICodeVisitor<ICode<CODE_ID>>(){

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                if (code.getParentCode() != null && !code.getParentCode().isActive() && code.isActive() && code instanceof AbstractCode) {
                    ((AbstractCode)code).setActiveInternal(false);
                }
                return true;
            }
        }, false);
    }

    protected void addRootCodeInternal(int index, CODE code) {
        if (code == null) {
            return;
        }
        int oldIndex = this.removeRootCodeInternal(code.getId());
        if (oldIndex >= 0 && index < 0) {
            index = oldIndex;
        }
        code.setCodeTypeInternal(this);
        code.setParentCodeInternal(null);
        this.m_rootCodeMap.put(code.getId(), code);
        if (index < 0) {
            this.m_rootCodeList.add(code);
        } else {
            this.m_rootCodeList.add(Math.min(index, this.m_rootCodeList.size()), code);
        }
    }

    protected int removeRootCodeInternal(CODE_ID codeId) {
        ICode droppedCode = (ICode)this.m_rootCodeMap.get(codeId);
        if (droppedCode == null) {
            return -1;
        }
        int index = -1;
        if (this.m_rootCodeList != null) {
            Iterator<CODE> it = this.m_rootCodeList.iterator();
            while (it.hasNext()) {
                ++index;
                ICode candidateCode = (ICode)it.next();
                if (candidateCode != droppedCode) continue;
                it.remove();
                break;
            }
        }
        droppedCode.setCodeTypeInternal(null);
        droppedCode.setParentCodeInternal(null);
        return index;
    }

    public String toString() {
        return "CodeType[id=" + this.getId() + ", label=" + this.getText() + "]";
    }

    @Override
    public <T extends ICode<CODE_ID>> boolean visit(ICodeVisitor<T> visitor) {
        return this.visit(visitor, true);
    }

    @Override
    public <T extends ICode<CODE_ID>> boolean visit(ICodeVisitor<T> visitor, boolean activeOnly) {
        for (ICode code : this.getCodes(activeOnly)) {
            if (!visitor.visit(code, 0)) {
                return false;
            }
            if (code.visit(visitor, 1, activeOnly)) continue;
            return false;
        }
        return true;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.m_rootCodeMap = new HashMap<CODE_ID, CODE>();
        if (this.m_rootCodeList == null) {
            this.m_rootCodeList = new ArrayList<CODE>();
        } else {
            for (ICode code : this.m_rootCodeList) {
                this.m_rootCodeMap.put(code.getId(), code);
                code.setParentCodeInternal(null);
                code.setCodeTypeInternal(this);
            }
        }
        return this;
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
    }

    protected static class LocalCodeTypeWithGenericExtension<CODE_TYPE_ID, CODE_ID, CODE extends ICode<CODE_ID>, OWNER extends AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE>>
    extends AbstractSerializableExtension<OWNER>
    implements ICodeTypeExtension<CODE_TYPE_ID, CODE_ID, OWNER> {
        private static final long serialVersionUID = 1L;

        public LocalCodeTypeWithGenericExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public List<? extends CODE> execCreateCodes(CodeTypeWithGenericChains.CodeTypeWithGenericCreateCodesChain chain) throws ProcessingException {
            return ((AbstractCodeTypeWithGeneric)this.getOwner()).execCreateCodes();
        }

        @Override
        public ICode<CODE_ID> execCreateCode(CodeTypeWithGenericChains.CodeTypeWithGenericCreateCodeChain chain, ICodeRow<CODE_ID> newRow) throws ProcessingException {
            return ((AbstractCodeTypeWithGeneric)this.getOwner()).execCreateCode(newRow);
        }

        @Override
        public List<? extends ICodeRow<CODE_ID>> execLoadCodes(CodeTypeWithGenericChains.CodeTypeWithGenericLoadCodesChain chain, Class<? extends ICodeRow<CODE_ID>> codeRowType) throws ProcessingException {
            return ((AbstractCodeTypeWithGeneric)this.getOwner()).execLoadCodes(codeRowType);
        }

        @Override
        public void execOverwriteCode(CodeTypeWithGenericChains.CodeTypeWithGenericOverwriteCodeChain chain, ICodeRow<CODE_ID> oldCode, ICodeRow<CODE_ID> newCode) throws ProcessingException {
            ((AbstractCodeTypeWithGeneric)this.getOwner()).execOverwriteCode(oldCode, newCode);
        }
    }
}

