/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield;

import java.util.List;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.IMobileTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtPagingSupport;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtScoutList;
import org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield.RwtScoutListModel;

public class RwtScoutMobileListModel
extends RwtScoutListModel {
    private static final long serialVersionUID = 1L;
    private RwtPagingSupport m_pagingSupport;

    public RwtScoutMobileListModel(IMobileTable scoutTable, RwtScoutList uiTable) {
        super((ITable)scoutTable, uiTable);
        if (scoutTable.isPagingEnabled()) {
            this.m_pagingSupport = new RwtPagingSupport(uiTable, scoutTable);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_pagingSupport != null) {
            this.m_pagingSupport.dispose();
            this.m_pagingSupport = null;
        }
    }

    public IMobileTable getScoutTable() {
        return (IMobileTable)super.getScoutTable();
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (this.m_pagingSupport == null) {
            return super.getElements(inputElement);
        }
        if (this.getScoutTable() != null) {
            List filteredRows = this.getScoutTable().getFilteredRows();
            return this.m_pagingSupport.getElementsOfCurrentPage(filteredRows).toArray();
        }
        return new Object[0];
    }

    public void setPagingEnabled(boolean enabled) {
        boolean refreshNecessary = false;
        if (enabled) {
            if (this.m_pagingSupport == null) {
                this.m_pagingSupport = new RwtPagingSupport(this.getUiList(), this.getScoutTable());
                refreshNecessary = true;
            }
        } else if (this.m_pagingSupport != null) {
            this.m_pagingSupport.dispose();
            this.m_pagingSupport = null;
            refreshNecessary = true;
        }
        if (refreshNecessary) {
            this.getUiList().getUiTableViewer().refresh();
        }
    }
}

