/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfo;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;

public class DeviceDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String BRANDING_SERVLET_MOBILE = "mobile";
    public static final String BRANDING_SERVLET_TABLET = "tablet";
    public static final String BRANDING_SERVLET_WEB = "web";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        if (StringUtility.isNullOrEmpty((CharSequence)pathInfo) || "/".equals(pathInfo)) {
            String targetServlet = this.computeBrandingServletName(request);
            response.sendRedirect(response.encodeRedirectURL(targetServlet));
        } else {
            response.sendError(404);
        }
    }

    protected String computeBrandingServletName(HttpServletRequest request) {
        BrowserInfo browserInfo = RwtUtility.createBrowserInfo((HttpServletRequest)request);
        if (browserInfo.isMobile()) {
            return BRANDING_SERVLET_MOBILE;
        }
        if (browserInfo.isTablet()) {
            return BRANDING_SERVLET_TABLET;
        }
        return BRANDING_SERVLET_WEB;
    }
}

