/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.services.common.clipboard;

import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.dnd.ImageTransferObject;
import org.eclipse.scout.commons.dnd.TextTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.dnd.TransferObjectRequest;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clipboard.IClipboardConsumer;
import org.eclipse.scout.rt.client.services.common.clipboard.IClipboardService;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

@Priority(value=-2.0f)
public class RwtScoutClipboardService
extends AbstractService
implements IClipboardService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutClipboardService.class);

    public void consumeContents(IClipboardConsumer clipboardConsumer, TransferObjectRequest ... requests) throws ProcessingException {
        IClientSession clientSession = ClientSyncJob.getCurrentSession();
    }

    public void setContents(final TransferObject transferObject) throws ProcessingException {
        try {
            if (transferObject == null || !transferObject.isText()) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Transfer transfer = RwtScoutClipboardService.this.createUiTransfer(transferObject.getClass());
                    if (transfer == null) {
                        throw new IllegalArgumentException("unsupported transfer object type: " + transferObject);
                    }
                    try {
                        Object contents = RwtUtility.createUiTransferable(transferObject);
                        if (contents != null) {
                            boolean cfr_ignored_0 = contents instanceof String;
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn("Cannot set system clipboard's contents", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            throw new ProcessingException("Cannot set system clipboard's contents", t);
        }
    }

    public void setTextContents(String textContents) throws ProcessingException {
        this.setContents((TransferObject)new TextTransferObject(textContents));
    }

    private TransferObject[] createScoutTransferables(TransferObjectRequest ... requests) {
        return null;
    }

    private Transfer createUiTransfer(Class<? extends TransferObject> transferObjectType) {
        if (TextTransferObject.class.equals(transferObjectType)) {
            return TextTransfer.getInstance();
        }
        if (ImageTransferObject.class.equals(transferObjectType)) {
            return ImageTransfer.getInstance();
        }
        return null;
    }

    private TransferObject createScoutTransferObject(Transfer transfer, Object contents) {
        if (transfer instanceof ImageTransfer) {
            return new ImageTransferObject(contents);
        }
        if (transfer instanceof TextTransfer) {
            return new TextTransferObject((String)contents);
        }
        return null;
    }
}

