/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.client.service.UrlLauncher;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.IUrlTarget;
import org.eclipse.scout.rt.client.ui.desktop.UrlTarget;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfo;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.filedownloader.RwtScoutDownloadHandler;

public class BrowserWindowHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BrowserWindowHandler.class);

    public void openLink(String link, IUrlTarget urlTarget) {
        if (link == null) {
            return;
        }
        if (UrlTarget.AUTO.equals((Object)urlTarget)) {
            urlTarget = this.computeTargetAuto(link);
        }
        if (UrlTarget.SELF.equals((Object)urlTarget)) {
            this.openLinkInSameBrowserWindow(link);
        } else if (UrlTarget.BLANK.equals((Object)urlTarget)) {
            this.openLinkInNewBrowserWindow(link);
        } else {
            this.downloadFile(link);
        }
    }

    protected IUrlTarget computeTargetAuto(String link) {
        if (this.isEmailLink(link) || this.isTelLink(link) || this.isSmsLink(link)) {
            return UrlTarget.SELF;
        }
        BrowserInfo browserInfo = RwtUtility.getBrowserInfo();
        if (BrowserInfo.System.OSX.equals((Object)browserInfo.getSystem()) && this.isAppleMapsLink(link)) {
            return UrlTarget.SELF;
        }
        if (this.isHttpLink(link)) {
            return UrlTarget.BLANK;
        }
        return UrlTarget.AUTO;
    }

    public boolean isEmailLink(String link) {
        return link != null && link.startsWith("mailto:");
    }

    public boolean isTelLink(String link) {
        return link != null && link.startsWith("tel:");
    }

    public boolean isSmsLink(String link) {
        return link != null && link.startsWith("sms:");
    }

    public boolean isHttpLink(String link) {
        return this.stringContains(link, new String[]{"http://", "https://"});
    }

    public void openLinkInNewBrowserWindow(String link) {
        if (link == null) {
            return;
        }
        UrlLauncher launcher = (UrlLauncher)RWT.getClient().getService(UrlLauncher.class);
        if (launcher != null) {
            launcher.openURL(link);
        }
    }

    public void openLinkInSameBrowserWindow(String link) {
        if (link == null) {
            return;
        }
        JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
        if (executor != null) {
            executor.execute("window.location='" + link + "'");
        }
    }

    public void downloadFile(String link) {
        try {
            File file = this.validateLink(link);
            String nextId = UUID.randomUUID().toString();
            RwtScoutDownloadHandler handler = new RwtScoutDownloadHandler(nextId, file, "", file.getName());
            handler.startDownload();
        }
        catch (IOException e) {
            LOG.error("Unexpected: " + link, (Throwable)e);
        }
    }

    public boolean isMapsLink(String link) {
        return this.isGoogleMapsLink(link) || this.isAppleMapsLink(link);
    }

    public boolean isAppleMapsLink(String link) {
        return this.stringContains(link, new String[]{"http://maps.apple.com", "https://maps.apple.com"});
    }

    public boolean isGoogleMapsLink(String link) {
        return this.stringContains(link, new String[]{"http://maps.google.com", "https://maps.google.com"});
    }

    protected boolean stringContains(String baseStr, String[] stringsToFind) {
        if (baseStr == null || stringsToFind == null) {
            return false;
        }
        int i = 0;
        while (i < stringsToFind.length) {
            if (baseStr.contains(stringsToFind[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected File validateLink(String link) throws IOException {
        String px = link.replace('\\', File.separatorChar);
        File file = new File(px);
        if (file.exists()) {
            px = file.getCanonicalPath();
            String osName = System.getProperty("os.name");
            if (osName != null && osName.startsWith("Mac OS")) {
                String ext = px.substring(px.lastIndexOf(46));
                File f = new File(file.getParentFile(), System.nanoTime() + ext);
                f.deleteOnExit();
                if (file.renameTo(f)) {
                    file = f;
                }
            }
        }
        return file;
    }
}

