/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfo;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.DefaultFormBoundsProvider;
import org.eclipse.scout.rt.ui.rap.window.IFormBoundsProvider;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutViewStack;
import org.eclipse.scout.rt.ui.rap.window.desktop.IViewTabSelectionListener;
import org.eclipse.scout.rt.ui.rap.window.desktop.RwtScoutDesktopForm;
import org.eclipse.scout.rt.ui.rap.window.desktop.ViewStackTabButton;
import org.eclipse.scout.rt.ui.rap.window.desktop.ViewTabSelectionEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RwtScoutViewStack
extends Composite
implements IRwtScoutViewStack {
    private static final long serialVersionUID = 1L;
    private static final String VARIANT_VIEW_PART = "viewPart";
    private static final String VARIANT_VIEW_PART_NO_RADIUS = "viewPartNoRadius";
    private static final String VARIANT_VIEW_TAB_AREA = "formTabArea";
    private int heightHint = -1;
    private int widthHint = -1;
    private IRwtEnvironment m_uiEnvironment;
    private HashMap<IForm, RwtScoutDesktopForm> m_openForms;
    private ArrayList<RwtScoutDesktopForm> m_formStack;
    private Map<IForm, IFormBoundsProvider> m_formBoundsProviders;
    private P_DesktopListner m_desktopListener;
    private Composite m_tabBar;
    private Composite m_container;

    public RwtScoutViewStack(Composite parent, IRwtEnvironment uiEnvironment) {
        super(parent, 0);
        this.m_uiEnvironment = uiEnvironment;
        this.m_openForms = new HashMap();
        this.m_formStack = new ArrayList(3);
        this.m_formBoundsProviders = new HashMap<IForm, IFormBoundsProvider>();
        this.addListener(11, new P_ResizeListener());
        this.m_desktopListener = new P_DesktopListner();
        this.getUiEnvironment().getScoutDesktop().addDesktopListener((DesktopListener)this.m_desktopListener);
        this.setData("org.eclipse.rap.rwt.customVariant", this.getVariant());
        this.createContent(this);
        this.addDisposeListener(new P_DisposeListener());
    }

    protected String getVariant() {
        BrowserInfo info = RwtUtility.getBrowserInfo();
        if (info != null && info.isMozillaFirefox()) {
            return VARIANT_VIEW_PART;
        }
        return VARIANT_VIEW_PART_NO_RADIUS;
    }

    protected void createContent(Composite parent) {
        if (this.isTabBarCreationEnabled()) {
            this.m_tabBar = this.getUiEnvironment().getFormToolkit().createComposite(parent);
            this.m_tabBar.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_VIEW_TAB_AREA);
        }
        this.m_container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        if (this.m_tabBar != null) {
            GridData tabBarData = new GridData(768);
            tabBarData.exclude = false;
            this.m_tabBar.setLayoutData((Object)tabBarData);
            RowLayout tabBarLayout = new RowLayout();
            tabBarLayout.marginBottom = 0;
            tabBarLayout.marginLeft = 0;
            tabBarLayout.marginTop = 0;
            this.m_tabBar.setLayout((Layout)tabBarLayout);
        }
        GridData containerData = new GridData(1808);
        this.m_container.setLayoutData((Object)containerData);
        StackLayout containerLayout = new StackLayout();
        this.m_container.setLayout((Layout)containerLayout);
    }

    @Override
    public IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    protected Map<IForm, IFormBoundsProvider> getFormBoundsProviders() {
        return this.m_formBoundsProviders;
    }

    @Override
    public IRwtScoutPart addForm(IForm form) {
        IFormBoundsProvider formBoundsProvider = this.createFormBoundsProvider(form, this.getUiEnvironment());
        this.m_formBoundsProviders.put(form, formBoundsProvider);
        this.initPreferredSize(formBoundsProvider);
        RwtScoutDesktopForm ui = this.createRwtScoutDesktopForm();
        ViewStackTabButton button = null;
        if (this.m_tabBar != null) {
            button = new ViewStackTabButton(this.m_tabBar);
            button.setLayoutData(new RowData(-1, 22));
            button.addViewTabListener(new P_ViewTabSelectionListener(ui));
        }
        ui.createPart(this, this.m_container, button, form, this.getUiEnvironment());
        this.m_formStack.add(0, ui);
        this.m_openForms.put(form, ui);
        this.setPartVisibleImpl(form);
        return ui;
    }

    protected RwtScoutDesktopForm createRwtScoutDesktopForm() {
        return new RwtScoutDesktopForm();
    }

    protected void initPreferredSize(IFormBoundsProvider boundsProvider) {
        if (boundsProvider == null) {
            return;
        }
        Rectangle formBounds = boundsProvider.getBounds();
        if (formBounds != null) {
            this.setWidthHint(formBounds.width);
            this.setHeightHint(formBounds.height);
        } else {
            this.setWidthHint(-1);
            this.setHeightHint(-1);
        }
    }

    protected IFormBoundsProvider createFormBoundsProvider(IForm scoutForm, IRwtEnvironment uiEnvironment) {
        return new DefaultFormBoundsProvider(scoutForm, uiEnvironment);
    }

    @Override
    public boolean isPartVisible(IRwtScoutPart part) {
        if ((part = (IRwtScoutPart)this.m_openForms.get(part.getScoutObject())) == null) {
            return false;
        }
        StackLayout stackLayout = (StackLayout)this.m_container.getLayout();
        return RwtUtility.isAncestorOf(stackLayout.topControl, (Control)part.getUiContainer());
    }

    @Override
    public void setPartVisible(IRwtScoutPart part) {
        if ((part = (IRwtScoutPart)this.m_openForms.get(part.getScoutObject())) == null) {
            return;
        }
        this.setPartVisibleImpl(part.getScoutObject());
    }

    private void removeForm(IForm form) {
        RwtScoutDesktopForm uiForm = this.m_openForms.remove(form);
        if (uiForm != null) {
            this.m_formStack.remove(uiForm);
            IForm topForm = null;
            if (this.m_formStack.size() > 0) {
                topForm = this.m_formStack.get(0).getScoutObject();
            }
            this.setPartVisibleImpl(topForm);
        }
        this.m_formBoundsProviders.remove(form);
    }

    protected void setPartVisibleImpl(IForm form) {
        RwtScoutDesktopForm uiForm = this.m_openForms.get(form);
        if (uiForm != null) {
            StackLayout stackLayout = (StackLayout)this.m_container.getLayout();
            stackLayout.topControl = uiForm.getUiContainer();
            if (this.m_tabBar != null && this.m_formStack.remove(uiForm)) {
                GridData tabBarData = (GridData)this.m_tabBar.getLayoutData();
                if (this.m_formStack.isEmpty()) {
                    this.m_tabBar.setVisible(false);
                    tabBarData.exclude = true;
                } else {
                    this.m_tabBar.setVisible(true);
                    tabBarData.exclude = false;
                    for (RwtScoutDesktopForm f : this.m_formStack) {
                        f.getTabButton().setActive(false);
                    }
                    uiForm.getTabButton().setActive(true);
                }
                this.m_formStack.add(0, uiForm);
            }
        }
        this.getParent().layout(true, true);
    }

    protected boolean isTabBarCreationEnabled() {
        return true;
    }

    public boolean getVisible() {
        return this.m_container.getChildren().length > 0;
    }

    @Override
    public int getHeightHint() {
        return this.heightHint;
    }

    @Override
    public void setHeightHint(int heightHint) {
        this.heightHint = heightHint;
    }

    @Override
    public int getWidthHint() {
        return this.widthHint;
    }

    @Override
    public void setWidthHint(int widthHint) {
        this.widthHint = widthHint;
    }

    private void handleScoutDesktopEvent(DesktopEvent e) {
        switch (e.getType()) {
            case 620: {
                this.setPartVisibleImpl(e.getForm());
                break;
            }
            case 610: {
                this.removeForm(e.getForm());
                break;
            }
            case 100: {
                this.handleDesktopClosed(e.getDesktop());
            }
        }
    }

    private void handleDesktopClosed(IDesktop desktop) {
        desktop.removeDesktopListener((DesktopListener)this.m_desktopListener);
        this.m_desktopListener = null;
    }

    private class P_DesktopListner
    implements DesktopListener {
        private P_DesktopListner() {
        }

        public void desktopChanged(final DesktopEvent e) {
            if (RwtScoutViewStack.this.getUiEnvironment().getDisplay() != null && !RwtScoutViewStack.this.getUiEnvironment().getDisplay().isDisposed()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutViewStack.this.handleScoutDesktopEvent(e);
                    }
                };
                RwtScoutViewStack.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }

    private class P_DisposeListener
    implements DisposeListener {
        private static final long serialVersionUID = 1L;

        private P_DisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            if (RwtScoutViewStack.this.m_desktopListener == null) {
                return;
            }
            RwtScoutViewStack.this.getUiEnvironment().getScoutDesktop().removeDesktopListener((DesktopListener)RwtScoutViewStack.this.m_desktopListener);
        }
    }

    private class P_ResizeListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_ResizeListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 11) {
                this.handleResized();
            }
        }

        private void handleResized() {
            if (RwtScoutViewStack.this.isDisposed() || RwtScoutViewStack.this.m_formBoundsProviders.isEmpty()) {
                return;
            }
            for (IFormBoundsProvider formBoundsProvider : RwtScoutViewStack.this.m_formBoundsProviders.values()) {
                formBoundsProvider.storeBounds(RwtScoutViewStack.this.getBounds());
            }
        }
    }

    private class P_ViewTabSelectionListener
    implements IViewTabSelectionListener {
        private final RwtScoutDesktopForm m_form;

        public P_ViewTabSelectionListener(RwtScoutDesktopForm form) {
            this.m_form = form;
        }

        @Override
        public void handleEvent(ViewTabSelectionEvent event) {
            if (event.getEventType() == 1) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        P_ViewTabSelectionListener.this.m_form.getScoutObject().getUIFacade().fireFormActivatedFromUI();
                    }
                };
                RwtScoutViewStack.this.getUiEnvironment().invokeScoutLater(job, 0L);
                RwtScoutViewStack.this.setPartVisibleImpl(this.m_form.getScoutObject());
            } else if (event.getEventType() == 2) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        P_ViewTabSelectionListener.this.m_form.getScoutObject().getUIFacade().fireFormClosingFromUI();
                    }
                };
                RwtScoutViewStack.this.getUiEnvironment().invokeScoutLater(job, 0L);
            }
        }
    }
}

