/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtility {
    private XmlUtility() {
    }

    public static List<Element> getChildElementsWithAttributes(Element parent, String tagName, String requiredAttributeName, String requiredAttributeValue) {
        NodeList endpoints = parent.getElementsByTagName(tagName);
        LinkedList<Element> result = new LinkedList<Element>();
        int i = 0;
        while (i < endpoints.getLength()) {
            String val;
            Element e;
            Node n = endpoints.item(i);
            if (n.getNodeType() == 1 && (e = (Element)n).hasAttribute(requiredAttributeName) && CompareUtility.equals(requiredAttributeValue, val = e.getAttribute(requiredAttributeName))) {
                result.add(e);
            }
            ++i;
        }
        return result;
    }

    public static void clearAttributes(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            element.removeAttribute(attributes.item(i).getNodeName());
            ++i;
        }
    }

    public static Object getObjectAttribute(Element element, String attribName) throws IOException, ClassNotFoundException {
        Object o = null;
        String base64 = element.getAttribute(attribName);
        if (base64.length() > 0) {
            byte[] raw = Base64Utility.decode(base64);
            o = SerializationUtility.createObjectSerializer().deserialize(raw, null);
        }
        return o;
    }

    public static void setObjectAttribute(Element element, String attribName, Object o) throws IOException {
        String base64 = null;
        if (o != null) {
            byte[] data = SerializationUtility.createObjectSerializer().serialize(o);
            base64 = Base64Utility.encode(data).trim();
        }
        element.setAttribute(attribName, base64);
    }

    public static void wellformDocument(Document document, OutputStream out) throws ProcessingException {
        XmlUtility.wellformDocument(document, new StreamResult(out));
    }

    public static void wellformDocument(Document document, File f) throws ProcessingException {
        boolean success;
        File dir = f.getParentFile();
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new ProcessingException("Unable to create directories for file '" + f.getAbsolutePath() + "'.");
        }
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(f, false);
                XmlUtility.wellformDocument(document, out);
            }
            catch (IOException e) {
                throw new ProcessingException("Exception writing xml file: '" + f.getAbsolutePath() + "'.", e);
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void wellformDocument(Document document, Writer writer) throws ProcessingException {
        XmlUtility.wellformDocument(document, new StreamResult(writer));
    }

    private static void wellformDocument(Document document, Result result) throws ProcessingException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 3);
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), result);
        }
        catch (TransformerException e) {
            throw new ProcessingException("Unable to wellform xml.", e);
        }
    }

    public static String wellformDocument(Document document) throws ProcessingException {
        StringWriter writer = new StringWriter();
        XmlUtility.wellformDocument(document, new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    public static String wellformXml(String rawXml) throws ProcessingException {
        return XmlUtility.wellformDocument(XmlUtility.getXmlDocument(rawXml));
    }

    public static Document createNewXmlDocument(String rootTagName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            document.appendChild(document.createElement(rootTagName));
            return document;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    public static Document getXmlDocument(InputStream is) throws ProcessingException {
        try {
            return XmlUtility.getDocumentBuilder().parse(is);
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
        catch (SAXException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
        catch (ParserConfigurationException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
    }

    public static Document getXmlDocument(File f) throws ProcessingException {
        try {
            return XmlUtility.getDocumentBuilder().parse(f);
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
        catch (SAXException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
        catch (ParserConfigurationException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
    }

    public static Document getXmlDocument(URL url) throws ProcessingException {
        InputStream is = null;
        try {
            is = url.openStream();
            Document document = XmlUtility.getXmlDocument(is);
            return document;
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to open URL '" + url.toExternalForm() + "'.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Document getXmlDocument(String rawXml) throws ProcessingException {
        try {
            return XmlUtility.getDocumentBuilder().parse(new InputSource(new StringReader(rawXml)));
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
        catch (SAXException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
        catch (ParserConfigurationException e) {
            throw new ProcessingException("Unable to load xml document.", e);
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        return docBuilder;
    }

    public static Element getFirstChildElement(Element parent, String tagName) {
        NodeList children = null;
        children = tagName == null ? parent.getChildNodes() : parent.getElementsByTagName(tagName);
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getChildElements(Element parent) {
        return XmlUtility.getChildElements(parent, null);
    }

    public static List<Element> getChildElements(Element parent, String tagName) {
        NodeList children = null;
        children = tagName == null ? parent.getChildNodes() : parent.getElementsByTagName(tagName);
        ArrayList<Element> result = new ArrayList<Element>(children.getLength());
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                result.add((Element)n);
            }
            ++i;
        }
        return result;
    }
}

