/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.dnd;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.dnd.TransferObject;

public class FileListTransferObject
extends TransferObject {
    private List<File> m_files;

    public FileListTransferObject(File ... files) {
        this(CollectionUtility.arrayList(files));
    }

    public FileListTransferObject(Collection<? extends File> files) {
        this.m_files = CollectionUtility.arrayListWithoutNullElements(files);
    }

    @Override
    public boolean isFileList() {
        return true;
    }

    public List<File> getFiles() {
        return CollectionUtility.arrayList(this.m_files);
    }

    public List<String> getFilenames() {
        return this.getFilenameList();
    }

    public List<String> getFilenameList() {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (this.m_files != null) {
            for (File f : this.m_files) {
                fileNames.add(f.getAbsolutePath());
            }
        }
        return fileNames;
    }

    public String toString() {
        return "FileListTransferObject[files=" + CollectionUtility.format(this.m_files) + "]";
    }
}

