/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.servlet;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.Binding;
import javax.xml.ws.http.HTTPBinding;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.Activator;
import org.eclipse.scout.jaxws.internal.servlet.ServletAdapter;
import org.eclipse.scout.jaxws.service.IJaxWsEndpointService;
import org.eclipse.scout.service.SERVICES;

public abstract class EndpointServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(EndpointServlet.class);
    private final Map<String, ServletAdapter> m_urlAdapterMap = new HashMap<String, ServletAdapter>();
    private boolean m_publishStatusPage;

    public void init() throws ServletException {
        super.init();
        this.installServletAdapters();
        this.publishStatusPage();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response, HTTPBinding.class);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response, HTTPBinding.class);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) {
        this.handleRequest(request, response, null);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response, Class<? extends Binding> bindingTypeFilter) {
        try {
            WSBinding candidateBinding;
            ServletAdapter adapter = this.resolveServletAdapter(request);
            if (adapter == null) {
                if (request.getMethod().equals("GET") && this.m_publishStatusPage) {
                    IJaxWsEndpointService endpointService = (IJaxWsEndpointService)SERVICES.getService(IJaxWsEndpointService.class);
                    Collection<ServletAdapter> servletAdapters = this.m_urlAdapterMap.values();
                    endpointService.onGetRequest(request, response, servletAdapters.toArray(new ServletAdapter[servletAdapters.size()]));
                    return;
                }
                response.sendError(404);
                return;
            }
            if (bindingTypeFilter != null && !bindingTypeFilter.isAssignableFrom((candidateBinding = adapter.getEndpoint().getBinding()).getClass())) {
                LOG.error("Illegal binding in webservice request. Must be of the type " + bindingTypeFilter.getName());
                response.sendError(405, "Illegal binding in webservie request.");
                return;
            }
            adapter.handle(this.getServletContext(), request, response);
        }
        catch (Exception e) {
            LOG.error("webservice request failed", (Throwable)e);
            try {
                response.sendError(500);
            }
            catch (IOException ioe) {
                response.setStatus(500);
            }
        }
    }

    protected void installServletAdapters() {
        IJaxWsEndpointService endpointService = (IJaxWsEndpointService)SERVICES.getService(IJaxWsEndpointService.class);
        ServletAdapter[] servletAdapterArray = endpointService.getServletAdapters();
        int n = servletAdapterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServletAdapter servletAdapter = servletAdapterArray[n2];
            String urlPattern = servletAdapter.getValidPath();
            if (urlPattern.contains("*.")) {
                LOG.warn("Failed to install JAX-WS endpoint '" + servletAdapter.getAlias() + "' due to unsupported URL pattern");
            } else if (this.m_urlAdapterMap.containsKey(urlPattern)) {
                LOG.warn("Failed to install JAX-WS endpoint '" + servletAdapter.getAlias() + "' due to duplicate URL pattern '" + urlPattern + "'");
            } else {
                this.m_urlAdapterMap.put(urlPattern, servletAdapter);
                LOG.info("Successfully installed JAX-WS endpoint '" + servletAdapter.getAlias() + "' on URL '" + urlPattern + "'");
            }
            ++n2;
        }
    }

    protected void publishStatusPage() {
        HttpAdapter.publishStatusPage = false;
        this.m_publishStatusPage = BooleanUtility.nvl((Boolean)((Boolean)TypeCastUtility.castValue((Object)Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.jaxws.publish_status_page"), Boolean.class)), (boolean)true);
    }

    protected ServletAdapter resolveServletAdapter(HttpServletRequest request) {
        String requestPath = request.getRequestURI().substring(request.getContextPath().length());
        ServletAdapter adapter = this.m_urlAdapterMap.get(requestPath);
        if (adapter != null) {
            return adapter;
        }
        for (ServletAdapter candidate : this.m_urlAdapterMap.values()) {
            if (!requestPath.matches("^" + Pattern.quote(candidate.getValidPath()) + "[\\/\\?]?.*$")) continue;
            return candidate;
        }
        return null;
    }
}

