/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.platform;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.prefs.UserScope;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.platform.IPlatformService;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooser;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

@Priority(value=-1.0f)
public class PlatformService
extends AbstractService
implements IPlatformService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PlatformService.class);

    @Override
    public boolean setProperty(String key, String value) {
        IClientSession session = ClientSyncJob.getCurrentSession();
        String id = String.valueOf(session.getBundle().getSymbolicName()) + "-" + session.getUserId();
        IEclipsePreferences prefs = new UserScope().getNode(id);
        String oldValue = prefs.get(key, null);
        if (value == null) {
            prefs.remove(key);
        } else {
            prefs.put(key, value);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                LOG.warn("storing property: " + key + "=" + value, (Throwable)e);
            }
        }
        return !CompareUtility.equals((Object)oldValue, (Object)value);
    }

    @Override
    public String getProperty(String key, String def) {
        IClientSession session = ClientSyncJob.getCurrentSession();
        String id = String.valueOf(session.getBundle().getSymbolicName()) + "-" + session.getUserId();
        IEclipsePreferences prefs = new UserScope().getNode(id);
        return prefs.get(key, def);
    }

    @Override
    public String getFile() {
        return this.getFile(null, true);
    }

    @Override
    public String getFile(String ext, boolean open) {
        return this.getFile(ext, open, null);
    }

    @Override
    public String getFile(String ext, boolean open, String curPath) {
        return this.getFile(ext, open, curPath, false);
    }

    @Override
    public String getFile(String ext, boolean open, String curPath, boolean folderMode) {
        if (curPath == null && (curPath = FileChooser.getCurrentDirectory()) == null) {
            try {
                IClientSession session = ClientSyncJob.getCurrentSession();
                curPath = Platform.getStateLocation((Bundle)session.getBundle()).toFile().getCanonicalPath();
            }
            catch (IOException io) {
                curPath = null;
            }
        }
        File f = null;
        List<File> a = new FileChooser(new File(curPath), Collections.singletonList(ext), open).startChooser();
        if (a.size() > 0) {
            f = a.get(0);
        }
        if (f != null) {
            if (f.isDirectory() != folderMode) {
                f = null;
            } else if (f.getAbsolutePath().indexOf(42) >= 0) {
                f = null;
            }
        }
        if (f != null) {
            FileChooser.setCurrentDirectory(f.getParent());
            return f.getAbsolutePath();
        }
        return null;
    }
}

