/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class DataModelAggregationLookupCall
extends LocalLookupCall<Integer> {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DataModelAggregationLookupCall.class);
    private IDataModelAttribute m_attribute;
    private List<ILookupRow<Integer>> m_lookupRows;

    public void setAttribute(IDataModelAttribute attribute) {
        if (this.m_attribute != attribute) {
            this.m_attribute = attribute;
            try {
                this.updateLookupRows();
            }
            catch (Throwable t) {
                LOG.error("Failed updating aggregation lookup rows for attribute " + attribute);
                this.m_lookupRows = CollectionUtility.emptyArrayList();
            }
        }
    }

    public IDataModelAttribute getAttribute() {
        return this.m_attribute;
    }

    protected void updateLookupRows() throws ProcessingException {
        ArrayList<ILookupRow<Integer>> result = new ArrayList<ILookupRow<Integer>>();
        int[] ags = null;
        if (this.m_attribute != null) {
            if (this.m_attribute.getType() != 17) {
                result.add((ILookupRow<Integer>)new LookupRow((Object)0, this.m_attribute.getText()));
            }
            if ((ags = this.m_attribute.getAggregationTypes()) != null && ags.length > 0) {
                int[] nArray = ags;
                int n = ags.length;
                int n2 = 0;
                while (n2 < n) {
                    int ag = nArray[n2];
                    String text = null;
                    switch (ag) {
                        case 5: {
                            text = ScoutTexts.get((String)"ComposerFieldAggregationAvg", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 1: {
                            if (this.m_attribute.getType() == 17) {
                                text = this.m_attribute.getText();
                                break;
                            }
                            text = ScoutTexts.get((String)"ComposerFieldAggregationCount", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 4: {
                            text = ScoutTexts.get((String)"ComposerFieldAggregationMax", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 6: {
                            text = ScoutTexts.get((String)"ComposerFieldAggregationMedian", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 3: {
                            text = ScoutTexts.get((String)"ComposerFieldAggregationMin", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 2: {
                            text = ScoutTexts.get((String)"ComposerFieldAggregationSum", (String[])new String[]{this.m_attribute.getText()});
                        }
                    }
                    result.add((ILookupRow<Integer>)new LookupRow((Object)ag, text));
                    ++n2;
                }
            }
        }
        this.m_lookupRows = result;
    }

    public List<ILookupRow<Integer>> getLookupRows() {
        return this.m_lookupRows;
    }

    protected List<ILookupRow<Integer>> execCreateLookupRows() throws ProcessingException {
        if (this.m_lookupRows != null) {
            return this.m_lookupRows;
        }
        return CollectionUtility.emptyArrayList();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            DataModelAggregationLookupCall other = (DataModelAggregationLookupCall)((Object)obj);
            return this.m_attribute == other.m_attribute;
        }
        return false;
    }
}

