/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servletfilter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.ConfigIniUtility;

public class FilterConfigInjection {
    private final javax.servlet.FilterConfig m_config;
    private final Class<? extends Filter> m_filterType;
    private final Object m_configCacheLock;
    private final Map<String, Map<String, String>> m_configCache;

    public FilterConfigInjection(javax.servlet.FilterConfig config, Class<? extends Filter> filterType) {
        this.m_config = config;
        this.m_filterType = filterType;
        this.m_configCacheLock = new Object();
        this.m_configCache = new HashMap<String, Map<String, String>>();
    }

    public FilterConfig getConfig(ServletRequest req) {
        if (req instanceof HttpServletRequest) {
            return this.getConfig(((HttpServletRequest)req).getServletPath());
        }
        return this.getConfig((String)null);
    }

    public FilterConfig getAnyConfig() {
        return this.getConfig((String)null);
    }

    public FilterConfig getConfig(String path) {
        if (path != null && path.startsWith("/")) {
            return new FilterConfig(this.getCachedPropertyMap(path));
        }
        return new FilterConfig(this.getCachedPropertyMap(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getCachedPropertyMap(String path) {
        Map map;
        if (path == null) {
            path = "";
        }
        Object object = this.m_configCacheLock;
        synchronized (object) {
            map = this.m_configCache.get(path);
            if (map == null) {
                map = path.length() == 0 ? ConfigIniUtility.getProperties(this.m_filterType) : ConfigIniUtility.getProperties(this.m_filterType, (String)path);
                if (map == null) {
                    map = new HashMap();
                }
                this.m_configCache.put(path, map);
            }
        }
        return map;
    }

    public class FilterConfig
    implements javax.servlet.FilterConfig {
        private final Map<String, String> m_injectedMap;

        public FilterConfig(Map<String, String> injectedMap) {
            this.m_injectedMap = injectedMap;
        }

        public boolean isActive() {
            String activeText = this.getInitParameter("active");
            return activeText == null || "true".equals(activeText);
        }

        public String getFilterName() {
            return FilterConfigInjection.this.m_config.getFilterName();
        }

        public ServletContext getServletContext() {
            return FilterConfigInjection.this.m_config.getServletContext();
        }

        public String getInitParameter(String name) {
            if (this.m_injectedMap.containsKey(name)) {
                return this.m_injectedMap.get(name);
            }
            String s = FilterConfigInjection.this.m_config.getInitParameter(name);
            return BundleContextUtility.resolve((String)s);
        }

        public Enumeration getInitParameterNames() {
            TreeSet<String> names = new TreeSet<String>(this.m_injectedMap.keySet());
            Enumeration en = FilterConfigInjection.this.m_config.getInitParameterNames();
            while (en.hasMoreElements()) {
                names.add((String)en.nextElement());
            }
            return new Vector<String>(names).elements();
        }
    }
}

